#include "opengatesrv.h"

/**********************************************************/
/* signal function WITHOUT SA_RESTART                     */
/**********************************************************/
Sigfunc* signalx(int signo, Sigfunc* func)
{
  struct sigaction act, oldact;

  act.sa_handler = func;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;

  if (sigaction(signo, &act, &oldact) < 0) return(SIG_ERR);
	
  return(oldact.sa_handler);
}

