/**************************************************
opengate server test program 

Copyright (C) 2005 Opengate Project Team
Written by Yoshiaki Watanabe
Modified Katsuhiko Eguchi, 2005 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	"opengatesrv.h"

/*********************/
/*  main routine     */
/*********************/
int  main(int argc, char **argv)
{
  int port;
  int connMode;
  char clientAddr4[100]="127.0.0.1";
  char clientAddr6[100]="::1";
  char userID[100]="user1";
  char language[100]="ja";
  char extraID[100]="";
  int duration=-60; 
  struct clientAddr ClientAddr;
  struct clientAddr *pClientAddr;

  pClientAddr = &ClientAddr;
  strlcpy(ClientAddr.ipAddr,"127.0.0.1",ADDRMAXLN);
  ClientAddr.next=NULL;
  strlcpy(ClientAddr.ruleNumber,"10000",WORDMAXLN);
  ClientAddr.ipType=IPV4;
  ClientAddr.timeIn=time(NULL);

  printf("This is a program to test watch client\n\n");

  /* prepare config file */
  OpenConfFile();
 
  /* start log */
  errToSyslog(atoi(GetConfValue("Syslog/Enable")));
  openlog(argv[0], LOG_PID, atoi(GetConfValue("Syslog/Facility")));

  /* init config */
  InitConf();

  SetupConfExtra(userID,extraID);

  port=GetListenPort();

  printf("Config file=[%s]\n",CONFIGFILE);
  printf("UserID=[%s]\n",userID);
  printf("ExtraID=[%s]\n",extraID);

  /* guide for connecting */
  printf("Waiting connection for %d seconds\n",duration);
  printf("\n");
  printf(" ### Try to connect from other window ###\n");
  printf("===============================================\n\n");
  printf("  Simulate Http connection \n");
  printf("===============================================\n");
  printf("PUT> telnet %s %d\n", clientAddr4, port);
  printf("PUT> GET /httpkeep-%s\n",userID);
  printf("PUT> (Enter)\n");
  printf("GET> http reply\n");
  printf("PUT> GET /hello\n");
  printf("PUT> (Enter)\n");
  printf("GET> http repry\n");
  printf("PUT> GET /terminate\n");
  printf("\n");
  printf("===============================================\n");
  printf("Following message is shown, because of no ipfw control. \n");
  printf("ipfw: rule 10000 does not exist\n");
  printf("===============================================\n\n");

  /* connection wait */
  connMode=WaitClientConnect(userID, "", "999",clientAddr4,clientAddr6, 
			     duration,"?","?",4,pClientAddr, language, port, 
			     99,1,"http://www.yahoo.com");
  switch(connMode){

  case HTTPCONNECT:
    WaitHttpClose(pClientAddr, userID, "", "?", "?", 4, "999", port);
    break;

  default:
    printf("Connection failed\n");
  }

  return 0;
}
