/**************************************************************************/
/* GE30 ( パラメータテーブル )                                            */
/*                                                                        */
/* Created : 2009/08/02 21:56:16                                          */
/**************************************************************************/
CREATE TABLE GE30 (
   SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 10  システムID        */
 , PTN_ID    VARCHAR2(20)                  NOT NULL      /* 20  定型文ID          */
 , FROM_ID   VARCHAR2(50)                  NOT NULL      /* 30  送信者ID          */
 , TO_ID     VARCHAR2(4000)                              /* 40  宛先（TO）        */
 , CC_ID     VARCHAR2(4000)                              /* 50  宛先（CC）        */
 , BCC_ID    VARCHAR2(4000)                              /* 60  宛先（BCC）       */
 , HEADER    VARCHAR2(1000)                              /* 70  ヘッダー自由文    */
 , FOOTER    VARCHAR2(1000)                              /* 80  フッター自由文    */
 , GAMEN_URL VARCHAR2(300)                               /* 90  画面URL（暗号化） */
 , PARAM0    VARCHAR2(1000)                              /* 100 パラメータ０      */
 , PARAM1    VARCHAR2(1000)                              /* 110 パラメータ１      */
 , PARAM2    VARCHAR2(1000)                              /* 120 パラメータ２      */
 , PARAM3    VARCHAR2(1000)                              /* 130 パラメータ３      */
 , PARAM4    VARCHAR2(1000)                              /* 140 パラメータ４      */
 , PARAM5    VARCHAR2(1000)                              /* 150 パラメータ５      */
 , PARAM6    VARCHAR2(1000)                              /* 160 パラメータ６      */
 , PARAM7    VARCHAR2(1000)                              /* 170 パラメータ７      */
 , PARAM8    VARCHAR2(1000)                              /* 180 パラメータ８      */
 , PARAM9    VARCHAR2(1000)                              /* 190 パラメータ９      */
 , ATTACH1   VARCHAR2(256)                               /* 200 添付１            */
 , ATTACH2   VARCHAR2(256)                               /* 210 添付２            */
 , ATTACH3   VARCHAR2(256)                               /* 220 添付３            */
 , ATTACH4   VARCHAR2(256)                               /* 230 添付４            */
 , ATTACH5   VARCHAR2(256)                               /* 240 添付５            */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 250 ユニークキー      */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 260 状態フラグ        */
 , DYSET     VARCHAR2(14)                                /* 270 登録日時          */
 , DYUPD     VARCHAR2(14)                                /* 280 更新日時          */
 , USRSET    VARCHAR2(10)                                /* 290 作成社員          */
 , USRUPD    VARCHAR2(10)                                /* 300 更新者            */
 , PRGUPD    VARCHAR2(10)                                /* 310 更新PRG           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE30S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE30T01 
BEFORE INSERT ON GE30
FOR EACH ROW 
BEGIN 
SELECT GE30S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

