/**************************************************************************/
/* GEA09 ( ユーザーアクセス画面管理テーブル )                             */
/*                                                                        */
/* Created : 2009/08/02 21:56:16                                          */
/**************************************************************************/
CREATE TABLE GEA09 (
   SYSTEM_ID   VARCHAR2(10)                 NOT NULL      /* 10  システムID       */
 , USERID      VARCHAR2(10)                 NOT NULL      /* 20  ユーザーID       */
 , GUIKEY      VARCHAR2(30)                 NOT NULL      /* 30  画面ID           */
 , SEQNO       NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  表示順           */
 , NAME_JA     VARCHAR2(120)                              /* 50  名称             */
 , LAST_ACCESS VARCHAR2(14)                               /* 60  最終アクセス時間 */
 , FGFAVORITE  VARCHAR2(1)                                /* 70  お気に入り       */
 , CLASSIFY    VARCHAR2(120)                              /* 80  分類             */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 90  ユニークキー     */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 100 状態フラグ       */
 , DYSET       VARCHAR2(14)                               /* 110 登録日時         */
 , DYUPD       VARCHAR2(14)                               /* 120 更新日時         */
 , USRSET      VARCHAR2(10)                               /* 130 作成社員         */
 , USRUPD      VARCHAR2(10)                               /* 140 更新者           */
 , PRGUPD      VARCHAR2(10)                               /* 150 更新PRG          */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GEA09S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GEA09T01 
BEFORE INSERT ON GEA09
FOR EACH ROW 
BEGIN 
SELECT GEA09S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

