/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.opengion.fukurou.util.Closer;

public final class ZipFileUtil {
    private static final int BUF_SIZE = 1024;

    private ZipFileUtil() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> unCompress(String string, String string2) {
        String string3 = string;
        if (File.separatorChar != string.charAt(string.length() - 1)) {
            string3 = string3 + File.separator;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ZipInputStream zipInputStream = null;
        ZipEntry zipEntry = null;
        BufferedOutputStream bufferedOutputStream = null;
        String string4 = null;
        File file = null;
        try {
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(string2)));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                string4 = string3 + zipEntry.getName().replace('/', File.separatorChar);
                arrayList.add(string4);
                boolean bl = true;
                file = new File(string4);
                if (zipEntry.isDirectory()) {
                    if (!file.exists()) {
                        bl = file.mkdirs();
                    }
                } else {
                    if (!file.getParentFile().exists()) {
                        bl = new File(string4).getParentFile().mkdirs();
                    }
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string4));
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    bufferedOutputStream.close();
                }
                if (bl) continue;
                System.err.println(string4 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string5 = "\u89e3\u51cd\u30d5\u30a1\u30a4\u30eb\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + string4 + "]";
                throw new RuntimeException(string5, fileNotFoundException);
                catch (IOException iOException) {
                    String string6 = "ZIP\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u51cd\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
                    throw new RuntimeException(string6, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(zipInputStream);
                Closer.ioClose(bufferedOutputStream);
                throw throwable;
            }
        }
        Closer.ioClose(zipInputStream);
        Closer.ioClose(bufferedOutputStream);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> compress(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string2)));
            File file = new File(string);
            ZipFileUtil.addZipEntry(zipOutputStream, arrayList, file, "", 0);
            zipOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string3 = "ZIP\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + string2 + "]";
                throw new RuntimeException(string3, fileNotFoundException);
                catch (IOException iOException) {
                    String string4 = "ZIP\u5727\u7e2e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
                    throw new RuntimeException(string4, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(zipOutputStream);
                throw throwable;
            }
        }
        Closer.ioClose(zipOutputStream);
        return arrayList;
    }

    private static void addZipEntry(ZipOutputStream zipOutputStream, List<String> list, File file, String string, int n) {
        BufferedInputStream bufferedInputStream = null;
        try {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray.length == 0) {
                    list.add(string + file.getName());
                    ZipEntry zipEntry = new ZipEntry(string + file.getName() + '/');
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.closeEntry();
                } else {
                    for (int i = 0; i < fileArray.length; ++i) {
                        String string2 = "";
                        if (n > 0) {
                            string2 = string + file.getName() + '/';
                        }
                        ZipFileUtil.addZipEntry(zipOutputStream, list, fileArray[i], string2, n + 1);
                    }
                }
            } else {
                int n2;
                list.add(string + file.getName());
                ZipEntry zipEntry = new ZipEntry(string + file.getName());
                zipOutputStream.putNextEntry(zipEntry);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
                byte[] byArray = new byte[1024];
                while ((n2 = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                }
                bufferedInputStream.close();
                zipOutputStream.closeEntry();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "\u5727\u7e2e\u5bfe\u8c61\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file.getName() + "]";
            throw new RuntimeException(string3, fileNotFoundException);
        }
        catch (IOException iOException) {
            String string4 = "ZIP\u5727\u7e2e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            throw new RuntimeException(string4, iOException);
        }
        finally {
            Closer.ioClose(bufferedInputStream);
        }
    }

    public static void main(String[] stringArray) {
        String string = "Usage: java [comp or uncomp] [targetPath] [zipFileName]";
        if (stringArray.length < 3) {
            System.out.println(string);
            return;
        }
        long l = System.currentTimeMillis();
        List<String> list = null;
        if ("comp".equals(stringArray[0])) {
            list = ZipFileUtil.compress(stringArray[1], stringArray[2]);
        } else if ("uncomp".equals(stringArray[0])) {
            list = ZipFileUtil.unCompress(stringArray[1], stringArray[2]);
        } else {
            System.out.println(string);
            return;
        }
        if (list != null) {
            for (String string2 : list) {
                System.out.println(string2);
            }
            System.out.println("\u51e6\u7406\u6642\u9593 : " + (System.currentTimeMillis() - l) + "(ms)");
        }
    }
}

