/**************************************************************************/
/* GEA10 ( ユーザー定義 )                                                 */
/*                                                                        */
/* Created : 2009/09/15 19:52:55                                          */
/**************************************************************************/
CREATE TABLE GEA10 (
   SYSTEM_ID VARCHAR2(10)                        NOT NULL      /* 10  システムID         */
 , USERID    VARCHAR2(10)                        NOT NULL      /* 20  ユーザーID         */
 , PASSWD    VARCHAR2(32)                        NOT NULL      /* 30  パスワード         */
 , LANG      VARCHAR2(2)                         NOT NULL      /* 40  言語               */
 , NAME      VARCHAR2(200)                                     /* 50  名称               */
 , ROLES     VARCHAR2(500)                       NOT NULL      /* 60  ロールズ           */
 , DROLES    VARCHAR2(500)                                     /* 70  データロールズ     */
 , COMMENTS  VARCHAR2(500)                                     /* 80  コメント           */
 , DYPASSWD  VARCHAR2(14)                                      /* 90  パスワード変更日時 */
 , DYVALID   VARCHAR2(8)      DEFAULT '99999999' NOT NULL      /* 100 有効日             */
 , FGDEFAULT VARCHAR2(1)      DEFAULT '0'                      /* 110 ログインFG         */
 , UNIQ      NUMBER(9)        DEFAULT 0          NOT NULL      /* 120 ユニークキー       */
 , FGJ       VARCHAR2(1)      DEFAULT '1'        NOT NULL      /* 130 状態フラグ         */
 , DYSET     VARCHAR2(14)                                      /* 140 登録日時           */
 , DYUPD     VARCHAR2(14)                                      /* 150 更新日時           */
 , USRSET    VARCHAR2(10)                                      /* 160 作成社員           */
 , USRUPD    VARCHAR2(10)                                      /* 170 更新者             */
 , PRGUPD    VARCHAR2(10)                                      /* 180 更新PRG            */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GEA10S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GEA10T01 
BEFORE INSERT ON GEA10
FOR EACH ROW 
BEGIN 
SELECT GEA10S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

