<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP03"
	title    = "レイアウトテーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- 変更はここからです。 -->

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck command = "{@command}" />

<!-- forward.jsp から command = "ENTRY" がセットされて遷移してくるので、DB登録画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" />

<og:value command = "SETTBL" key = "LISTID" separator="','" action = "APPEND"/>

<!-- 通常は変更する必要はありません。 -->
<og:tableUpdate
	command				= "{@command}"
	queryType			= "JDBCTableUpdate"
	commitTableModel	= "false" >
<jsp:text>{@SQL}</jsp:text>
</og:tableUpdate>

<og:query
	command		= "RENEW"
	quotCheck	= "false">
	<jsp:text>
		SELECT SYSTEM_ID,LISTID,KBTEXT,COLUMN_NAME,SEQ,USE_LENGTH,START_POS
			,'' SQL_TYPE,'' SQL_BODY
		FROM GE52
		WHERE FGJ = '1'
		AND LISTID IN ('{@LISTID}')
		ORDER BY SYSTEM_ID,LISTID,KBTEXT,SEQ
	</jsp:text>
</og:query>
<og:tableFilter classId="REPORTLAYOUT" keys="SUBSTRB" vals="{@DBF.SUBSTRB}" selectedAll="true" />
<og:tableUpdate
	command		= "{@command}"
	selectedAll = "true"
	queryType	= "JDBCTableUpdate" 
	conditionKey	= "SQL_TYPE"
	conditionList	= "H|F|B"
	commitTableModel= "false">
	<jsp:text>
		UPDATE GE54 SET
			HSQL = CASE WHEN [SQL_TYPE] = 'H' THEN [SQL_BODY] ELSE HSQL END
			,FSQL = CASE WHEN [SQL_TYPE] = 'F' THEN [SQL_BODY] ELSE FSQL END
			,BSQL = CASE WHEN [SQL_TYPE] = 'B' THEN [SQL_BODY] ELSE BSQL END
			,FGJ = '1'
		WHERE SYSTEM_ID = [SYSTEM_ID]
		AND LISTID = [LISTID]
	</jsp:text>
</og:tableUpdate>
<og:tableUpdate
	command		= "{@command}"
	selectedAll = "true"
	queryType	= "JDBCTableUpdate">
	<jsp:text>
		UPDATE GE52 SET
			SEQ = [SEQ]
			,START_POS = [START_POS]
		WHERE SYSTEM_ID = [SYSTEM_ID]
		AND LISTID = [LISTID]
		AND KBTEXT = [KBTEXT]
		AND COLUMN_NAME = [COLUMN_NAME]
	</jsp:text>
</og:tableUpdate>

<og:value command="SET" key="LISTID" value="" />

<!-- 更新後のレイアウト変更自動更新スクリプトの実行 -->
<!-- GE54 帳票定義マスタのFGJ(状態フラグ) を '0' にすることで、トリガを起動します。-->
<!--
<og:tableUpdate
	command   = "{@command}"
	queryType = "JDBCTableUpdate" >
<jsp:text>
	update GE54 set FGJ = '0'
	where 	SYSTEM_ID	= [SYSTEM_ID]
	and		LISTID		= [LISTID]
</jsp:text>
</og:tableUpdate>
-->

<!-- 変更はここまでです。 -->

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
