/**************************************************************************/
/* GE34 ( 宛先テーブル )                                                  */
/*                                                                        */
/* Created : 2009/09/15 19:52:54                                          */
/**************************************************************************/
CREATE TABLE GE34 (
   YKNO     NUMBER(9)        DEFAULT 0   NOT NULL      /* 10  要求ＮＯ       */
 , GROUP_ID VARCHAR2(20)                               /* 20  グループID     */
 , DST_ID   VARCHAR2(10)                 NOT NULL      /* 30  社員番号       */
 , DST_NAME VARCHAR2(100)                              /* 40  名前           */
 , DST_ADDR VARCHAR2(100)                              /* 50  メールアドレス */
 , DST_KBN  VARCHAR2(1)                  NOT NULL      /* 60  送信区分       */
 , UNIQ     NUMBER(9)        DEFAULT 0   NOT NULL      /* 70  ユニークキー   */
 , FGJ      VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 80  状態フラグ     */
 , DYSET    VARCHAR2(14)                               /* 90  登録日時       */
 , DYUPD    VARCHAR2(14)                               /* 100 更新日時       */
 , USRSET   VARCHAR2(10)                               /* 110 作成社員       */
 , USRUPD   VARCHAR2(10)                               /* 120 更新者         */
 , PRGUPD   VARCHAR2(10)                               /* 130 更新PRG        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE34S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE34T01 
BEFORE INSERT ON GE34
FOR EACH ROW 
BEGIN 
SELECT GE34S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

