/**************************************************************************/
/* GF23 ( TAGLIB使用例ファイル )                                          */
/*                                                                        */
/* Created : 2009/09/15 19:52:56                                          */
/**************************************************************************/
CREATE TABLE GF23 (
   VERSION     VARCHAR2(10)                  NOT NULL      /* 10  バージョン   */
 , TAGCLASS    VARCHAR2(100)                 NOT NULL      /* 20  TAGクラス名  */
 , HTMLEXT     VARCHAR2(1)                                 /* 30  HTMLEXT      */
 , DESCRIPTION VARCHAR2(4000)                              /* 40  概要説明     */
 , CONTENTS    CLOB                                        /* 50  内容         */
 , FORM_SAMPLE CLOB                                        /* 60  形式サンプル */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 70  ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 80  状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 90  登録日時     */
 , DYUPD       VARCHAR2(14)                                /* 100 更新日時     */
 , USRSET      VARCHAR2(10)                                /* 110 作成社員     */
 , USRUPD      VARCHAR2(10)                                /* 120 更新者       */
 , PRGUPD      VARCHAR2(10)                                /* 130 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 14336K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF23S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF23T01 
BEFORE INSERT ON GF23
FOR EACH ROW 
BEGIN 
SELECT GF23S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

