/**************************************************************************/
/* GF24 ( JAVADOCクラス定義ファイル )                                     */
/*                                                                        */
/* Created : 2009/09/15 19:52:56                                          */
/**************************************************************************/
CREATE TABLE GF24 (
   VERSION     VARCHAR2(10)                  NOT NULL      /* 10  バージョン   */
 , TAGCLASS    VARCHAR2(100)                 NOT NULL      /* 20  TAGクラス名  */
 , VALUENAME   VARCHAR2(30)                  NOT NULL      /* 30  属性名称     */
 , HTMLEXT     VARCHAR2(1)                                 /* 40  HTMLEXT      */
 , DESCRIPTION VARCHAR2(4000)                              /* 50  概要説明     */
 , CONTENTS    CLOB                                        /* 60  内容         */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 70  ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 80  状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 90  登録日時     */
 , DYUPD       VARCHAR2(14)                                /* 100 更新日時     */
 , USRSET      VARCHAR2(10)                                /* 110 作成社員     */
 , USRUPD      VARCHAR2(10)                                /* 120 更新者       */
 , PRGUPD      VARCHAR2(10)                                /* 130 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 39936K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF24S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF24T01 
BEFORE INSERT ON GF24
FOR EACH ROW 
BEGIN 
SELECT GF24S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

