/**************************************************************************/
/* GF72 ( 登録ボタン状態テーブル )                                        */
/*                                                                        */
/* Created : 2009/09/15 19:52:56                                          */
/**************************************************************************/
CREATE TABLE GF72 (
   SYSTEM_ID  VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ADDRESS    VARCHAR2(256)                              /* 20  アドレス     */
 , FILENAME   VARCHAR2(30)                               /* 30  ファイル名   */
 , FILEPATH   VARCHAR2(256)                              /* 40  ファイルパス */
 , MODIFIED   VARCHAR2(14)                               /* 50  最終更新日   */
 , TAGNAME    VARCHAR2(30)                               /* 60  タグ名称     */
 , TO_GAMENID VARCHAR2(30)                               /* 70  先画面ID     */
 , HREF       VARCHAR2(256)                              /* 80  リンク先URL  */
 , TARGET     VARCHAR2(10)                               /* 90  ターゲット   */
 , KEYS       VARCHAR2(500)                              /* 100 引数キー     */
 , VALS       VARCHAR2(500)                              /* 110 引数値       */
 , COMMAND    VARCHAR2(30)                               /* 120 コマンド     */
 , LBLCD      VARCHAR2(30)                               /* 130 ラベルコード */
 , MSGCD      VARCHAR2(20)                               /* 140 メッセージID */
 , ONCLICK    VARCHAR2(200)                              /* 150 イベント     */
 , ROLES      VARCHAR2(500)                              /* 160 ロールズ     */
 , FGOMIT     VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 170 除外フラグ   */
 , UNIQ       NUMBER(9)        DEFAULT 0   NOT NULL      /* 180 ユニークキー */
 , FGJ        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 190 状態フラグ   */
 , DYSET      VARCHAR2(14)                               /* 200 登録日時     */
 , DYUPD      VARCHAR2(14)                               /* 210 更新日時     */
 , USRSET     VARCHAR2(10)                               /* 220 作成社員     */
 , USRUPD     VARCHAR2(10)                               /* 230 更新者       */
 , PRGUPD     VARCHAR2(10)                               /* 240 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF72S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF72T01 
BEFORE INSERT ON GF72
FOR EACH ROW 
BEGIN 
SELECT GF72S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

