<!-- include ファイルは、jsp:text が使用できません。  -->
<og:message lbl="GFM0004" val0="{@YEAR}" val1="{@BLOCK}" comment=" 年 地区 営業所別 売上比率 グラフ" />

<og:chartCreate
	width		= "400"
	height		= "200"
>
	<og:chartDataset
		chartType	= "Pie"
	>
		select BRANCH,SUM(SALES) AS SALES
		from GF43
		where YEAR  = '{@YEAR}'
		and   BLOCK = '{@BLOCK}'
		group by BRANCH
		order by SALES DESC
	</og:chartDataset>
</og:chartCreate>

<hr />
<og:message lbl="GFM0005" val0="{@YEAR}" val1="{@BLOCK}" comment=" 年 地区 営業所別 売上順グラフ" />

<og:chartCreate
	imageMapUrl = "index.jsp?YEAR={@YEAR}&amp;FLAG={@FLAG}&amp;command=NEW,BRANCH,SALES"
	imageMapTarget = "CONTENTS"
	width		= "600"
	height		= "400"
>
	<og:chartDataset
		chartType	= "Bar"
	>
		select BRANCH,SUM(SALES) AS SALES, SUM(AMOUNT) AS AMOUNT, 
				SUM(SALES-AMOUNT) AS PROFIT
		from GF43
		where YEAR  = '{@YEAR}'
		and   BLOCK = '{@BLOCK}'
		group by BRANCH
		order by SALES DESC
	</og:chartDataset>
</og:chartCreate>

<hr />
<og:message lbl="GFM0006" val0="{@YEAR}" val1="{@BLOCK}" comment=" 年 地区 月別 売上・経費・利益推移グラフ" />

<og:chartCreate
	width		= "600"
	height		= "400"
>
	<og:chartDataset
		chartType	= "LineAndShape"
	>
		select MONTH,SUM(SALES) AS SALES, SUM(AMOUNT) AS AMOUNT, SUM(SALES-AMOUNT) AS PROFIT
		from GF43
		where YEAR  = '{@YEAR}'
		and   BLOCK = '{@BLOCK}'
		group by MONTH
		order by MONTH
	</og:chartDataset>
</og:chartCreate>
