<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7070"
	title	= "Valueタグ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "TABLESPACE_NAME,SYSTEM_ID,TBLSYU,NAME_JA"
	nullCheck = "SYSTEM_ID"
/>

<og:entry command = "{@command}"  />

<!--
<og:file action = "exists" file1="GF01.xml"  >
	<og:forward page="query.jsp" keys="command" vals="RENEW" />
</og:file>
<og:message comment="GF01.xml がありません。エラーです。" />
-->

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select TBLSYU,TABLESPACE_NAME,NAME_JA,FILE_NAME,
				SIZE_AUTO,SIZE_DATA,STATUS,SYSTEM_ID,
				FGJ,UNIQ
		from GF01
	</jsp:text>
	<og:where>
		<og:and value = "FGJ             in  ('0','1')"              />
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"       />
		<og:and value = "TBLSYU          like '{@TBLSYU}%'"          />
		<og:and value = "TABLESPACE_NAME like '{@TABLESPACE_NAME}%'" />
		<og:and value = "NAME_JA         like '{@NAME_JA}%'"         />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,TABLESPACE_NAME,TBLSYU" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="NAME_JA" gamenId="GF2000" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TBLSYU,TABLESPACE_NAME"
		vals="NEW,[SYSTEM_ID],[TBLSYU],[TABLESPACE_NAME]" />
	<og:link column="TABLESPACE_NAME" gamenId="GF2010" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TBLSYU,TABLESPACE_NAME"
		vals="NEW,[SYSTEM_ID],[TBLSYU],[TABLESPACE_NAME]" />
</og:viewLink>

<og:viewMarker command="{@command}">
	<og:columnMarker column="FILE_NAME" >
		<img src="../image/pc.gif" alt="[FILE_NAME]" />
	</og:columnMarker>
</og:viewMarker>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="setTable"      lbl="SET_TABLE"      command="VIEW" />
	<og:submit  value="getTable"      lbl="GET_TABLE"      command="VIEW" />
	<og:submit  value="keyTable"      lbl="KEY_TABLE"      command="VIEW" />
	<og:submit  value="rotationTable" lbl="ROTATION_TABLE" command="NEW" />
</og:writeCheck>

<table><tr>
	<og:select name="action" lbl="ACTION" >
		<og:option value=""           lbl=""       selected="selected" />
		<og:option value="UPPER"      lbl="UPPER"		/>
		<og:option value="LOWER"      lbl="LOWER"		/>
		<og:option value="APPEND"     lbl="APPEND"		/>
		<og:option value="ALL_APPEND" lbl="ALL_APPEND"	/>
		<og:option value="MERGE"      lbl="MERGE"		/>
		<og:option value="FIRST"      lbl="FIRST"		/>
	</og:select>
	<og:column name="separator" value="," size="5" />
</tr></table>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}" />
<og:hidden name="pageSize" value="{@pageSize}" />
<og:hidden name="SYSTEM_ID" value="{@SYSTEM_ID}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
