/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.fukurou.util.TagBuffer;

/**
 * YMD エディターは、カラムのデータを日付（年/月/日）編集する場合に使用するクラスです。
 *
 * 
 * このエディタはeventColumnに対応していません。
 * 
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 3.5.6.2 (2004/07/05) 新規作成
 * @og.group データ編集
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_YMD2 extends AbstractEditor {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

//	private static final String CAL1 = "<img src=\"../image/calendar.gif\" alt=\"Calendar\" onclick=\"window_open('../common/calendar.html',event,'" ;
//	private static final String CAL2 = "','width=220px,height=170px,resizable=no');\">";
	// 4.1.1.2 (2008/03/07) カレンダーポップアップのモーダル化
	private static final String CAL1 = "<button onclick=\"ogPopup('../common/calendar.html',250,265,null,this,new Array('" ; 
//	private static final String CAL2 = "'),event); \" style=\"background-color:Beige;border:0px\"><img src=\"../image/calendar.gif\" alt=\"Calendar\"/></button>";
	// 4.3.6.7 (2009/05/22) FireFox対応
	private static final String CAL2 = "'),event); return false;\" style=\"background-color:Beige;border:0px\"><img src=\"../image/calendar.gif\" alt=\"Calendar\"/></button>";

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Editor_YMD2() {
		// 4.3.4.4 (2009/01/01)
//		super();
	}

	/**
	 * コンストラクター。
	 *
	 * @param   clm DBColumn オブジェクト
	 */
	private Editor_YMD2( final DBColumn clm ) {
		super( clm );
		tagBuffer.add( XHTMLTag.inputAttri( attributes ) );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param   clm DBColumn オブジェクト
	 * @return  CellEditor オブジェクト
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_YMD2( clm );
	}

	/**
	 * データの編集用文字列を返します。
	 * 
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 *
	 * @param	value String
	 * @return	データの編集用文字列
	 */
	public String getValue( final String value ) {
		TagBuffer tag = new TagBuffer( "input" );
		tag.add( "name"    , name );
		if( attributes.get( "id" ) == null || attributes.get( "id" ).length() == 0 ) { // 4.3.7.2 (2009/06/15)
			tag.add( "id"      , name );
		}
		tag.add( "value"   , value );
		tag.add( "size"    , size1 );
		tag.add( tagBuffer.makeTag() );
		tag.add( optAttr );		// 3.5.5.8 (2004/05/20)

		return tag.makeTag() + CAL1 + name + CAL2 ;
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 * 
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 *
	 * @param	row   int 行番号
	 * @param	value String
	 * @return	データ表示/編集用の文字列
	 */
	public String getValue( final int row,final String value ) {
		TagBuffer tag = new TagBuffer( "input" );
		String name2 =  name + HybsSystem.JOINT_STRING + row ;
		tag.add( "name"    , name2);
		if( attributes.get( "id" ) == null || attributes.get( "id" ).length() == 0 ) { // 4.3.7.2 (2009/06/15)
			tag.add( "id"      , name2);
		}
		tag.add( "value"   , value );
		tag.add( "size"    , size2 );
		tag.add( tagBuffer.makeTag() );
		tag.add( optAttr );		// 3.5.5.8 (2004/05/20)

		return tag.makeTag( row,value ) + CAL1 + name2 + CAL2 ;
	}
}
