/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;

public final class DBUtil {
    private static final String CR = System.getProperty("line.separator");

    private DBUtil() {
    }

    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo) {
        return DBUtil.dbExecute(string, stringArray, applicationInfo, null);
    }

    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        return DBUtil.dbExecute(string, stringArray, applicationInfo, string2, false);
    }

    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2, boolean bl) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String[][] stringArray2 = null;
        boolean bl2 = true;
        try {
            int n;
            connection = ConnectionFactory.connection(string2, applicationInfo);
            preparedStatement = connection.prepareStatement(string);
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    preparedStatement.setObject(n + 1, stringArray[n]);
                }
            }
            if ((n = preparedStatement.execute()) != 0) {
                resultSet = preparedStatement.getResultSet();
                stringArray2 = DBUtil.resultToArray(resultSet, bl);
            } else {
                connection.commit();
            }
            bl2 = false;
        }
        catch (SQLException sQLException) {
            try {
                Closer.rollback(connection);
                String string3 = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + "SQL=[" + string + "]" + CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + CR + "DBID=[" + string2 + "]" + CR;
                throw new RuntimeException(string3, sQLException);
            }
            catch (Throwable throwable) {
                Closer.resultClose(resultSet);
                Closer.stmtClose(preparedStatement);
                if (bl2) {
                    ConnectionFactory.remove(connection, string2);
                } else {
                    ConnectionFactory.close(connection, string2);
                }
                throw throwable;
            }
        }
        Closer.resultClose(resultSet);
        Closer.stmtClose(preparedStatement);
        if (bl2) {
            ConnectionFactory.remove(connection, string2);
        } else {
            ConnectionFactory.close(connection, string2);
        }
        return stringArray2;
    }

    public static String[] dbCallExecute(String string, String[] stringArray, ApplicationInfo applicationInfo) {
        return DBUtil.dbCallExecute(string, stringArray, applicationInfo, null);
    }

    public static String[] dbCallExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        Connection connection = null;
        CallableStatement callableStatement = null;
        String[] stringArray2 = new String[2];
        boolean bl = true;
        try {
            connection = ConnectionFactory.connection(string2, applicationInfo);
            callableStatement = connection.prepareCall(string);
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 12);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    callableStatement.setObject(i + 3, (Object)stringArray[i]);
                }
            }
            callableStatement.execute();
            stringArray2[0] = String.valueOf(callableStatement.getInt(1));
            stringArray2[1] = callableStatement.getString(2);
            connection.commit();
            bl = false;
        }
        catch (SQLException sQLException) {
            try {
                Closer.rollback(connection);
                String string3 = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + "SQL=[" + string + "]" + CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + CR + "DBID=[" + string2 + "]" + CR;
                throw new RuntimeException(string3, sQLException);
            }
            catch (Throwable throwable) {
                Closer.stmtClose(callableStatement);
                if (bl) {
                    ConnectionFactory.remove(connection, string2);
                } else {
                    ConnectionFactory.close(connection, string2);
                }
                throw throwable;
            }
        }
        Closer.stmtClose(callableStatement);
        if (bl) {
            ConnectionFactory.remove(connection, string2);
        } else {
            ConnectionFactory.close(connection, string2);
        }
        return stringArray2;
    }

    public static int dbExist(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = -1;
        boolean bl = true;
        try {
            connection = ConnectionFactory.connection(string2, applicationInfo);
            preparedStatement = connection.prepareStatement(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setObject(i + 1, stringArray[i]);
                }
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                n = resultSet.getInt(1);
            }
            bl = false;
        }
        catch (SQLException sQLException) {
            try {
                String string3 = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + "SQL=[" + string + "]" + CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + CR + "DBID=[" + string2 + "]" + CR;
                throw new RuntimeException(string3, sQLException);
            }
            catch (Throwable throwable) {
                Closer.resultClose(resultSet);
                Closer.stmtClose(preparedStatement);
                if (bl) {
                    ConnectionFactory.remove(connection, string2);
                } else {
                    ConnectionFactory.close(connection, string2);
                }
                throw throwable;
            }
        }
        Closer.resultClose(resultSet);
        Closer.stmtClose(preparedStatement);
        if (bl) {
            ConnectionFactory.remove(connection, string2);
        } else {
            ConnectionFactory.close(connection, string2);
        }
        return n;
    }

    public static String[][] resultToArray(ResultSet resultSet, boolean bl) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            int n;
            String[] stringArray;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            if (bl) {
                stringArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = resultSetMetaData.getColumnLabel(n + 1).toUpperCase(Locale.JAPAN);
                }
                arrayList.add(stringArray);
            }
            while (resultSet.next()) {
                stringArray = new String[n2];
                for (n = 1; n <= n2; ++n) {
                    Object object = resultSet.getObject(n);
                    stringArray[n - 1] = object == null ? "" : String.valueOf(object);
                }
                arrayList.add(stringArray);
            }
        }
        catch (SQLException sQLException) {
            String string = "\u51e6\u7406\u7d50\u679c\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + sQLException.getMessage();
            throw new RuntimeException(string, sQLException);
        }
        int n = arrayList.size();
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String[])arrayList.get(i);
        }
        return stringArray;
    }
}

