/**************************************************************************/
/* GEA08 ( 項目名称定義（ラベル） )                                       */
/*                                                                        */
/* Created : 2009/09/30 19:57:41                                          */
/**************************************************************************/
CREATE TABLE GEA08 (
   SYSTEM_ID     VARCHAR2(10)                  NOT NULL      /* 10  システムID     */
 , LANG          VARCHAR2(2)                   NOT NULL      /* 20  言語           */
 , CLM           VARCHAR2(30)                  NOT NULL      /* 30  項目           */
 , NAME_JA       VARCHAR2(120)                               /* 40  名称           */
 , SNAME         VARCHAR2(60)                                /* 50  名前(短)       */
 , LNAME         VARCHAR2(500)                               /* 60  名前(長)       */
 , COMMENTS      VARCHAR2(500)                               /* 70  コメント       */
 , CDKH          VARCHAR2(1)                                 /* 80  改廃コード     */
 , FGLOAD        VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 90  読込F          */
 , KBSAKU        VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 100 作成区分       */
 , UNIQ          NUMBER(9)         DEFAULT 0   NOT NULL      /* 110 ユニークキー   */
 , FGJ           VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 120 状態フラグ     */
 , DYSET         VARCHAR2(14)                                /* 130 登録日時       */
 , DYUPD         VARCHAR2(14)                                /* 140 更新日時       */
 , USRSET        VARCHAR2(10)                                /* 150 作成社員       */
 , USRUPD        VARCHAR2(10)                                /* 160 更新者         */
 , PRGUPD        VARCHAR2(10)                                /* 170 更新PRG        */
 , RELEASE_NOTES VARCHAR2(120)                               /* 180 リリースノート */
 , RDC_CODE      VARCHAR2(20)                                /* 190 設変番号       */
 , DESCRIPTION   VARCHAR2(4000)                              /* 200 概要説明       */
 , KBLBL         VARCHAR2(1)                   NOT NULL      /* 210 ラベル区分     */
)
TABLESPACE GETBL01
STORAGE( INITIAL 640K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GEA08S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GEA08T01 
BEFORE INSERT ON GEA08
FOR EACH ROW 
BEGIN 
SELECT GEA08S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

