/***************************************************************************
 * 3.8.6.0 (2006/09/29)
 * Common Function
 * Modified: 2009/02/09 Hard-coded Highlight background color
 * Modified: 2009/05/14 Extend to Firefox
 * Revision: $Id$
 ***************************************************************************/
var csHilightBGColor = "rgb(160,230,200)";

function getParentByTagName( oOneChild, sTagName, sInTagName ) {
	var oParent = oOneChild;
	while( oParent ) {
		if( sTagName == oParent.tagName ) { break; }
		if( sInTagName && ( oParent.tagName == sInTagName ) ) {
			oParent = null;
			break;
		}
		oParent = oParent.parentNode;
	}
	return oParent;
}

function getRowClicked( oOneChild ) {
	var oParent = oOneChild;
	var l_sTagName;
	while( oParent ) {
		l_sTagName = oParent.tagName;
		if( ( ( "TR" == l_sTagName ) || ( "TBODY" == l_sTagName ) ) && oParent.className.indexOf( "row_" ) > -1 ) {
			break;
		}
		oParent = oParent.parentNode;
	}
	return oParent;
}

function getTable( oOneChild ) {
	return getParentByTagName( oOneChild, "TABLE" );
}

function IsTextField( oClicked ) {
	var bRet = false;
	switch( oClicked.tagName ) {
		case "TD"		:
		case "CENTER"	:
		case "SPAN"		:
		case "DIV"		:
		case "PRE"		:
		case "STYLE"	:
		case "FONT"		:
		case "B"		:
		case "STRONG"	:
		case "A"		: // 4.3.6.6 (2009/05/15)
			bRet = true;
			break;
		default:
			break;
	}
	return bRet;
}

// Simplified currentStyle
function getCurrentStyle( element, property, pseudo ) {
	if( element.currentStyle ) {  //IE or Opera
		var property = property.replace(/\-(\w)/g, function(all, letter){
			return letter.toUpperCase();
		});
		return element.currentStyle[ property ];
	}
	else if( getComputedStyle ) { //Mozilla or Opera
		property = property.replace( /([A-Z])/g, "-$1" ).toLowerCase();
		return getComputedStyle( element, pseudo || null ).getPropertyValue( property );
	}

	return "";
}

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +  Hilight Row																	 +
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// var csHybsCheckMarker = "h_rowSelected";
var csHybsCheckMarker = "h_rowSel";

function getHybsChkFromTBody(oTBody) {
    var oCheck = null;
	var oChecks  = oTBody.getElementsByTagName( "INPUT" );
	for(var nIndexUp = 0; nIndexUp < oChecks.length ; nIndexUp++ ) {
		if( csHybsCheckMarker == oChecks[nIndexUp].name ) {
			oCheck		= oChecks[nIndexUp];
			break;
		}
	}
    return oCheck;
}

function hilightRow( evt, isCheckOnly ) {
	var oClicked = null, bShiftKey = false;
	var evt = ( evt ) ? evt : ( ( window.event ) ? window.event : null );
	if( evt ) {
		oClicked = ( evt.target ) ? evt.target : ( ( evt.srcElement ) ? evt.srcElement : null );
		bShiftKey = ("undefined" != typeof evt.shiftKey) ? evt.shiftKey : (evt.modifiers && (evt.modifiers & Event.SHIFT_MASK));
	}

	if( oClicked ) {
		var bProcess = true;

		// 4.3.7.0 (2009/06/01)
		if( isCheckOnly && oClicked.name != csHybsCheckMarker ) {
			bProcess = false;
		}

		if( ( "INPUT" == oClicked.tagName ) && ( "submit" == oClicked.type ) ) {
			bProcess = false;
		}

		//var oTBody =getTBody( oClicked );
		var oTBody = getRowClicked( oClicked );
		var oInnerTbls = oClicked.getElementsByTagName( "TABLE" );
		if( bProcess && oInnerTbls.length <= 0 && oTBody && oTBody.className != "row_h" ) {
			var oRadio = getHybsChkFromTBody(oTBody);
			var bRadioType;
			if(oRadio) bRadioType	= ( "radio" == oRadio.type || "A" == oClicked.tagName );  // 4.3.6.6 (2009/05/15) リンク対応

			var oTable = getTable( oTBody );
			if( bRadioType ) {
                // 2009/02/09 in radio button table : oldTBody -> oldTBody2
				if( !( oTable.oldTBody2 && oTable.oldTBody2 == oTBody ) ) {
					 if( oTable.oldTBody2 ) {
						 //oTable.oldTBody.className	= oTable.oldClassName;
						 oTable.oldTBody2.style.backgroundColor	= oTable.oldBGColor;
						 oTable.oldRadio.checked	= false;
					 }
					oTable.oldTBody2 	= oTBody;
					//oTable.oldClassName = oTBody.className;
					//oTable.oldBGColor	= oTBody.currentStyle.backgroundColor;
					oTable.oldBGColor	= getCurrentStyle(oTBody, "background-color");
					oTable.oldRadio 	= oRadio;
					//oTBody.className	= "row_hilight";
					oTBody.style.backgroundColor	= csHilightBGColor;
					oRadio.checked		= true;
				}
			}
			else {
				if(bShiftKey) {
					var oOldTBody = oTable.oldTBody || oTBody;
					var oRunTBody, oEndTBody, oRunRadio;

					var bTBodyIsAfter; // 2009/05/14
					if(document.documentElement.compareDocumentPosition) { // FireFox
						var nPosMark = oOldTBody.compareDocumentPosition(oTBody);
						bTBodyIsAfter = ((4 == nPosMark) || (0 == nPosMark));
					}
					else { // IE
						bTBodyIsAfter = (oOldTBody.sourceIndex <=  oTBody.sourceIndex);
					}

					//if(oOldTBody.sourceIndex <=  oTBody.sourceIndex) {
					if(bTBodyIsAfter) {
						oRunTBody = oOldTBody;
						oEndTBody = oTBody;
					}
					else {
						oRunTBody = oTBody;
						oEndTBody = oOldTBody;
					}
					while(true) {
						//if(!oRunTBody.oldClassName) {
						if(!oRunTBody.oldBGColor) {
							//oRunTBody.oldClassName	= oRunTBody.className	;
							//oRunTBody.className		= "row_hilight";
							//oRunTBody.oldBGColor	= oRunTBody.currentStyle.backgroundColor;
							oRunTBody.oldBGColor	= getCurrentStyle(oRunTBody, "background-color");
							oRunTBody.style.backgroundColor	= csHilightBGColor;
						}
						oRunRadio = getHybsChkFromTBody(oRunTBody);
						if(oRunRadio && !oRunRadio.checked) oRunRadio.checked	= true;

						if(oRunTBody == oEndTBody) break;

						do { oRunTBody = oRunTBody.nextSibling; }
						while( oRunTBody && oRunTBody.nodeType != 1 );
					}
					oTable.oldTBody 	= oTBody;
				}
				else {
					// 4.1.0.0（2008/01/17）行選択及びハイライト処理を行う。
					//if( oTBody.oldClassName ) {
//					if( oTBody.oldBGColor ) {
					// 5.0.0.3 (2009/09/22)
					// チェックボックスの状態で行ハイライトを行うかどうかを判定する
					// イベント発行元が、行チェックの場合、イベント発行後の状態で判定
					// する必要があるため、通常の場合と条件が判定している
					if(    ( oClicked.name == csHybsCheckMarker && !oRadio.checked )
						|| ( oClicked.name != csHybsCheckMarker && oRadio.checked ) ) {
						if( (oClicked == oRadio) || IsTextField( oClicked ) ) {
							//oTBody.className	= oTBody.oldClassName;
							//oTBody.oldClassName	= "";
							oTBody.style.backgroundColor = oTBody.oldBGColor;
							oTBody.oldBGColor	= "";
							if( oRadio ) { 
								oRadio.checked	= false;
							}
							oTable.oldTBody 	= oTBody;
						}
					}
					else {
						//oTBody.oldClassName	= oTBody.className;
						//oTBody.className	= "row_hilight";
						//oTBody.oldBGColor	= oTBody.currentStyle.backgroundColor;
						oTBody.oldBGColor	= getCurrentStyle(oTBody, "background-color");
						oTBody.style.backgroundColor = csHilightBGColor;
						if( oRadio ) { 
							oRadio.checked	= true; 
						}
						oTable.oldTBody 	= oTBody;
					}
				}
			}
		}
	}
}
