#!/bin/sh
# /***********************************************************************/
# /*  このファイルでは、openGionを起動するための環境変数を設定します。   */
# /*  通常、このファイルを変更する必要はありません。                     */
# /***********************************************************************/

# /***********************************************************************/
# /*  JavaとTomcatのパス設定です。                                       */
# /***********************************************************************/
export APPS=$(cd $(dirname $0);pwd)/../../apps
export UAP=$(cd $(dirname $0);pwd)/..

export JAVA_HOME=$APPS/$JDK_VER
export CATALINA_HOME=$APPS/$TOMCAT_VER
export OFFICE_HOME=$APPS/$OPENOFFICE_VER

# /***********************************************************************/
# /*  Tomcatのserver.xmlに引き渡す各種変数設定                           */
# /***********************************************************************/
export ENGINE_NAME=tomcat
export APP_BASE=$UAP/webapps
export SYS_LOG_URL=log/$COMPUTERNAME_$ENGINE_NAME_$(date +%F).log
export WORK_DIR=$CATALINA_HOME/work/$(hostname)/$ENGINE_NAME
export LOGS_DIR=$CATALINA_HOME/logs/$(hostname)/$ENGINE_NAME

# /***********************************************************************/
# /*  OpenOffice帳票用設定                                               */
# /*                                                                     */
# /***********************************************************************/
export CLASSPATH=:$CLASSPATH:$OFFICE_HOME/basis-link/program/classes/juh.jar:$OFFICE_HOME/basis-link/program/classes/unoil.jar:
export PATH=:$PATH:$OFFICE_HOME/program:$OFFICE_HOME/basis-link/program:$OFFICE_HOME/ure/bin:
export LD_LIBRARY_PATH=:$LD_LIBRARY_PATH:$OFFICE_HOME/ure/lib:

# /***********************************************************************/
# /*  コンテキストパスの設定                                             */
# /***********************************************************************/
export DEV_PATH=$APP_BASE/$DEV_CTXT
export CORE_PATH=$APP_BASE/$CORE_CTXT

# /***********************************************************************/
# /*  その他設定                                                         */
# /***********************************************************************/
export CATALINA_OPTS="$CATALINA_OPTS -server $JAVA_OPTS -DshutdownPort=$SHUTDOWN_PORT -DconnectorPort=$CONNECTOR_PORT -DajpPort=$AJP_PORT -DengineName=$ENGINE_NAME -DconnectionDriver=$REALM_DRIVER -DconnectionUrl=$REALM_URL -DconnectionName=$REALM_NAME -DconnectionPassword=$REALM_PASSWORD -DappBase=$APP_BASE -DworkDir=$WORK_DIR -DlogsDir=$LOGS_DIR -DSYS_LOG_URL=$SYS_LOG_URL -Xloggc:$LOGS_DIR/gc.log -XX:+PrintGCDetails -XX:+PrintClassHistogram"

export PATH=:$PATH:$JAVA_HOME/bin:
export TITLE=$TOMCAT_VER
