/**************************************************************************/
/* GF02 ( テーブル定義 )                                                  */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF02 (
   SYSTEM_ID       VARCHAR2(10)                 NOT NULL      /* 10  システムID               */
 , TBLSYU          VARCHAR2(1)                  NOT NULL      /* 20  テーブル種別             */
 , TABLE_NAME      VARCHAR2(50)                 NOT NULL      /* 30  テーブル名               */
 , NAME_JA         VARCHAR2(120)                              /* 40  名称                     */
 , TABLESPACE_NAME VARCHAR2(30)                 NOT NULL      /* 50  テーブルスペース名       */
 , INITIAL_AUTO    NUMBER(10)       DEFAULT 0   NOT NULL      /* 60  自動計算初期エクステント */
 , INITIAL_EXTENT  NUMBER(10)       DEFAULT 16  NOT NULL      /* 70  初期エクステント(KB)     */
 , NEXT_EXTENT     NUMBER(10)       DEFAULT 16  NOT NULL      /* 80  ＮＥＸＴエクステント     */
 , COMMENTS        VARCHAR2(500)                              /* 90  コメント                 */
 , UNIQ            NUMBER(9)        DEFAULT 0   NOT NULL      /* 100 ユニークキー             */
 , FGJ             VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 110 状態フラグ               */
 , DYSET           VARCHAR2(14)                               /* 120 登録日時                 */
 , DYUPD           VARCHAR2(14)                               /* 130 更新日時                 */
 , USRSET          VARCHAR2(10)                               /* 140 作成社員                 */
 , USRUPD          VARCHAR2(10)                               /* 150 更新者                   */
 , PRGUPD          VARCHAR2(10)                               /* 160 更新PRG                  */
 , SKENSU          NUMBER(9)        DEFAULT 0   NOT NULL      /* 170 想定件数                 */
 , JKENSU          NUMBER(9)        DEFAULT 0   NOT NULL      /* 180 実件数                   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 320K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF02S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF02T01 
BEFORE INSERT ON GF02
FOR EACH ROW 
BEGIN 
SELECT GF02S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

