/**************************************************************************/
/* GF07 ( インデックスカラム定義 )                                        */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF07 (
   SYSTEM_ID  VARCHAR2(10)                NOT NULL      /* 10  システムID     */
 , TBLSYU     VARCHAR2(1)                 NOT NULL      /* 20  テーブル種別   */
 , TABLE_NAME VARCHAR2(50)                NOT NULL      /* 30  テーブル名     */
 , INDEX_NAME VARCHAR2(30)                NOT NULL      /* 40  インデックス名 */
 , CLM        VARCHAR2(30)                NOT NULL      /* 50  項目           */
 , SEQNO      NUMBER(7)       DEFAULT 0   NOT NULL      /* 60  表示順         */
 , UNIQ       NUMBER(9)       DEFAULT 0   NOT NULL      /* 70  ユニークキー   */
 , FGJ        VARCHAR2(1)     DEFAULT '1' NOT NULL      /* 80  状態フラグ     */
 , DYSET      VARCHAR2(14)                              /* 90  登録日時       */
 , DYUPD      VARCHAR2(14)                              /* 100 更新日時       */
 , USRSET     VARCHAR2(10)                              /* 110 作成社員       */
 , USRUPD     VARCHAR2(10)                              /* 120 更新者         */
 , PRGUPD     VARCHAR2(10)                              /* 130 更新PRG        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF07S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF07T01 
BEFORE INSERT ON GF07
FOR EACH ROW 
BEGIN 
SELECT GF07S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

