/**************************************************************************/
/* GF25 ( JAVADOC属性定義ファイル )                                       */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF25 (
   VERSION     VARCHAR2(10)                  NOT NULL      /* 10  バージョン   */
 , ATTCLASS    VARCHAR2(100)                 NOT NULL      /* 20  ATTCLASS     */
 , SEQ         NUMBER(5)         DEFAULT 0   NOT NULL      /* 30  順           */
 , ATTKEY      VARCHAR2(30)                  NOT NULL      /* 40  属性クラス   */
 , VALUENAME   VARCHAR2(30)                  NOT NULL      /* 50  属性名称     */
 , DESCRIPTION VARCHAR2(4000)                              /* 60  概要説明     */
 , CONTENTS    CLOB                                        /* 70  内容         */
 , FORM_SAMPLE CLOB                                        /* 80  形式サンプル */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 90  ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 100 状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 110 登録日時     */
 , DYUPD       VARCHAR2(14)                                /* 120 更新日時     */
 , USRSET      VARCHAR2(10)                                /* 130 作成社員     */
 , USRUPD      VARCHAR2(10)                                /* 140 更新者       */
 , PRGUPD      VARCHAR2(10)                                /* 150 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 8192K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF25S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF25T01 
BEFORE INSERT ON GF25
FOR EACH ROW 
BEGIN 
SELECT GF25S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

