/**************************************************************************/
/* GF28 ( 対訳テーブル )                                                  */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF28 (
   GENBUN    VARCHAR2(500)                NOT NULL      /* 10  原文         */
 , LANG_GEN  VARCHAR2(2)                  NOT NULL      /* 20  原文言語     */
 , LANG_YAKU VARCHAR2(2)                  NOT NULL      /* 30  訳文言語     */
 , KBYAKU    VARCHAR2(1)                  NOT NULL      /* 40  訳文区分     */
 , YAKU      VARCHAR2(500)                              /* 50  訳文         */
 , ID        VARCHAR2(30)                               /* 60  ID           */
 , COMMENTS  VARCHAR2(500)                              /* 70  コメント     */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 80  ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 90  状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 100 登録日時     */
 , DYUPD     VARCHAR2(14)                               /* 110 更新日時     */
 , USRSET    VARCHAR2(10)                               /* 120 作成社員     */
 , USRUPD    VARCHAR2(10)                               /* 130 更新者       */
 , PRGUPD    VARCHAR2(10)                               /* 140 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 768K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF28S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF28T01 
BEFORE INSERT ON GF28
FOR EACH ROW 
BEGIN 
SELECT GF28S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

