/**************************************************************************/
/* GF61 ( タイプ定義 )                                                    */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF61 (
   IDTYPE VARCHAR2(20)                 NOT NULL      /* 10  IDタイプ        */
 , NAME   VARCHAR2(200)                              /* 20  名称            */
 , DEFM1  VARCHAR2(30)                               /* 30  項目定義マスタ1 */
 , DEFM2  VARCHAR2(30)                               /* 40  項目定義マスタ2 */
 , DEFM3  VARCHAR2(30)                               /* 50  項目定義マスタ3 */
 , DEFM4  VARCHAR2(30)                               /* 60  項目定義マスタ4 */
 , DEFM5  VARCHAR2(30)                               /* 70  項目定義マスタ5 */
 , DEFM6  VARCHAR2(30)                               /* 80  項目定義マスタ6 */
 , UNIQ   NUMBER(9)        DEFAULT 0   NOT NULL      /* 90  ユニークキー    */
 , FGJ    VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 100 状態フラグ      */
 , DYSET  VARCHAR2(14)                               /* 110 登録日時        */
 , DYUPD  VARCHAR2(14)                               /* 120 更新日時        */
 , USRSET VARCHAR2(10)                               /* 130 作成社員        */
 , USRUPD VARCHAR2(10)                               /* 140 更新者          */
 , PRGUPD VARCHAR2(10)                               /* 150 更新PRG         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF61S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF61T01 
BEFORE INSERT ON GF61
FOR EACH ROW 
BEGIN 
SELECT GF61S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

