/**************************************************************************/
/* GF64 ( タスクツリー )                                                  */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF64 (
   PRJCODE      VARCHAR2(30)                                /* 10  PRJコード         */
 , TASK_ID      NUMBER(5)                                   /* 20  タスクID          */
 , SEQ          NUMBER(5)         DEFAULT 0   NOT NULL      /* 30  順                */
 , TASK_LEVEL   NUMBER(2)                                   /* 40  レベル            */
 , NAME         VARCHAR2(200)                               /* 50  名称              */
 , MEETING      VARCHAR2(1)       DEFAULT '0'               /* 60  マイルストーン    */
 , DYSTART      VARCHAR2(14)                                /* 70  開始日            */
 , DURATION     NUMBER(4,1)                                 /* 80  期間              */
 , COMPLETE     NUMBER(3)                                   /* 90  進捗率            */
 , PRIORITY     VARCHAR2(1)                                 /* 100 優先度            */
 , NOTES        VARCHAR2(4000)                              /* 110 ノート            */
 , COLOR        VARCHAR2(7)                                 /* 120 カラー            */
 , SHAPE        VARCHAR2(16)                                /* 130 模様              */
 , DEPEND_ID1   NUMBER(5)                                   /* 140 DEPEND_ID1        */
 , DEPEND_TYPE1 VARCHAR2(1)                                 /* 150 先行タスクタイプ1 */
 , DEPEND_ID2   NUMBER(5)                                   /* 160 DEPEND_ID2        */
 , DEPEND_TYPE2 VARCHAR2(1)                                 /* 170 先行タスクタイプ2 */
 , DEPEND_ID3   NUMBER(5)                                   /* 180 DEPEND_ID3        */
 , DEPEND_TYPE3 VARCHAR2(1)                                 /* 190 先行タスクタイプ3 */
 , DEPEND_ID4   NUMBER(5)                                   /* 200 DEPEND_ID4        */
 , DEPEND_TYPE4 VARCHAR2(1)                                 /* 210 先行タスクタイプ4 */
 , DEPEND_ID5   NUMBER(5)                                   /* 220 DEPEND_ID5        */
 , DEPEND_TYPE5 VARCHAR2(1)                                 /* 230 先行タスクタイプ5 */
 , UNIQ         NUMBER(9)         DEFAULT 0   NOT NULL      /* 240 ユニークキー      */
 , FGJ          VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 250 状態フラグ        */
 , DYSET        VARCHAR2(14)                                /* 260 登録日時          */
 , DYUPD        VARCHAR2(14)                                /* 270 更新日時          */
 , USRSET       VARCHAR2(10)                                /* 280 作成社員          */
 , USRUPD       VARCHAR2(10)                                /* 290 更新者            */
 , PRGUPD       VARCHAR2(10)                                /* 300 更新PRG           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF64S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF64T01 
BEFORE INSERT ON GF64
FOR EACH ROW 
BEGIN 
SELECT GF64S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

