/**************************************************************************/
/* GF73 ( 使用カラム状態テーブル )                                        */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF73 (
   SYSTEM_ID   VARCHAR2(10)                  NOT NULL      /* 10  システムID     */
 , ADDRESS     VARCHAR2(256)                               /* 20  アドレス       */
 , FILENAME    VARCHAR2(30)                                /* 30  ファイル名     */
 , FILEPATH    VARCHAR2(256)                               /* 40  ファイルパス   */
 , MODIFIED    VARCHAR2(14)                                /* 50  最終更新日     */
 , TAGNAME     VARCHAR2(30)                                /* 60  タグ名称       */
 , FORM_TYPE   VARCHAR2(10)                                /* 70  フォームタイプ */
 , NAME        VARCHAR2(200)                               /* 80  名称           */
 , VALUE       VARCHAR2(1000)                              /* 90  値             */
 , DEFAULT_VAL VARCHAR2(100)                               /* 100 デフォルト値   */
 , LBLCD       VARCHAR2(30)                                /* 110 ラベルコード   */
 , MSGCD       VARCHAR2(20)                                /* 120 メッセージID   */
 , MUST        VARCHAR2(10)                                /* 130 必須           */
 , VIEW_LENGTH VARCHAR2(10)                                /* 140 表示桁数       */
 , USE_LENGTH  VARCHAR2(9)       DEFAULT '0' NOT NULL      /* 150 使用桁数       */
 , CODE_CLM    VARCHAR2(30)                                /* 160 コードカラム   */
 , READONLY    VARCHAR2(10)                                /* 170 読取専用       */
 , DISABLED    VARCHAR2(10)                                /* 180 無効           */
 , ROLES       VARCHAR2(500)                               /* 190 ロールズ       */
 , TEXT        CLOB                                        /* 200 テキスト       */
 , FGOMIT      VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 210 除外フラグ     */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 220 ユニークキー   */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 230 状態フラグ     */
 , DYSET       VARCHAR2(14)                                /* 240 登録日時       */
 , DYUPD       VARCHAR2(14)                                /* 250 更新日時       */
 , USRSET      VARCHAR2(10)                                /* 260 作成社員       */
 , USRUPD      VARCHAR2(10)                                /* 270 更新者         */
 , PRGUPD      VARCHAR2(10)                                /* 280 更新PRG        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF73S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF73T01 
BEFORE INSERT ON GF73
FOR EACH ROW 
BEGIN 
SELECT GF73S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

