/**************************************************************************/
/* GF75 ( JavaScript状態テーブル )                                        */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF75 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID           */
 , ADDRESS   VARCHAR2(256)                              /* 20  アドレス             */
 , FILENAME  VARCHAR2(30)                               /* 30  ファイル名           */
 , FILEPATH  VARCHAR2(256)                              /* 40  ファイルパス         */
 , MODIFIED  VARCHAR2(14)                               /* 50  最終更新日           */
 , TAGNAME   VARCHAR2(30)                               /* 60  タグ名称             */
 , SRC_FILE  VARCHAR2(250)                              /* 70  インクルードファイル */
 , FGOMIT    VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 80  除外フラグ           */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 90  ユニークキー         */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 100 状態フラグ           */
 , DYSET     VARCHAR2(14)                               /* 110 登録日時             */
 , DYUPD     VARCHAR2(14)                               /* 120 更新日時             */
 , USRSET    VARCHAR2(10)                               /* 130 作成社員             */
 , USRUPD    VARCHAR2(10)                               /* 140 更新者               */
 , PRGUPD    VARCHAR2(10)                               /* 150 更新PRG              */
)
TABLESPACE GETBL01
STORAGE( INITIAL 320K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF75S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF75T01 
BEFORE INSERT ON GF75
FOR EACH ROW 
BEGIN 
SELECT GF75S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

