/**************************************************************************/
/* GF80 ( DB定義書マスタテーブル )                                        */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF80 (
   SYSTEM_ID    VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , TBLSYU       VARCHAR2(1)                   NOT NULL      /* 20  テーブル種別 */
 , TABLE_NAME   VARCHAR2(50)                  NOT NULL      /* 30  テーブル名   */
 , NAME_JA      VARCHAR2(120)                               /* 40  名称         */
 , SEQNO        NUMBER(7)         DEFAULT 0   NOT NULL      /* 50  表示順       */
 , CLM_NAME     VARCHAR2(120)                               /* 60  項目名(漢字) */
 , CLM          VARCHAR2(30)                  NOT NULL      /* 70  項目         */
 , CLS_NAME     VARCHAR2(10)                  NOT NULL      /* 80  DBクラス     */
 , PHY_LENGTH   VARCHAR2(10)                                /* 90  物理桁数     */
 , USE_LENGTH   VARCHAR2(9)       DEFAULT '0' NOT NULL      /* 100 使用桁数     */
 , UK           VARCHAR2(2)                                 /* 110 UK           */
 , IXA          VARCHAR2(2)                                 /* 120 IXA          */
 , IXB          VARCHAR2(2)                                 /* 130 IXB          */
 , IXC          VARCHAR2(2)                                 /* 140 IXC          */
 , IXD          VARCHAR2(2)                                 /* 150 IXD          */
 , IXE          VARCHAR2(2)                                 /* 160 IXE          */
 , IXF          VARCHAR2(2)                                 /* 170 IXF          */
 , IXG          VARCHAR2(2)                                 /* 180 IXG          */
 , NOT_NULL     VARCHAR2(1)                                 /* 190 NOT NULL     */
 , C_KEY        VARCHAR2(1)                                 /* 200 C_KEY        */
 , F_KEY        VARCHAR2(1)                                 /* 210 F_KEY        */
 , RENDERER     VARCHAR2(10)                                /* 220 表示種別     */
 , EDITOR       VARCHAR2(10)                                /* 230 編集種別     */
 , DBTYPE       VARCHAR2(10)                                /* 240 文字種別     */
 , DATA_DEFAULT VARCHAR2(30)                                /* 250 初期値       */
 , KBCLM        VARCHAR2(1)                                 /* 260 カラム区分   */
 , BIKO         VARCHAR2(2000)                              /* 270 備考         */
 , UNIQ         NUMBER(9)         DEFAULT 0   NOT NULL      /* 280 ユニークキー */
 , FGJ          VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 290 状態フラグ   */
 , DYSET        VARCHAR2(14)                                /* 300 登録日時     */
 , DYUPD        VARCHAR2(14)                                /* 310 更新日時     */
 , USRSET       VARCHAR2(10)                                /* 320 作成社員     */
 , USRUPD       VARCHAR2(10)                                /* 330 更新者       */
 , PRGUPD       VARCHAR2(10)                                /* 340 更新PRG      */
 , CDKH         VARCHAR2(1)                                 /* 350 改廃コード   */
 , COMMENTS     VARCHAR2(500)                               /* 360 コメント     */
)
TABLESPACE GETBL01
STORAGE( INITIAL 3072K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF80S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF80T01 
BEFORE INSERT ON GF80
FOR EACH ROW 
BEGIN 
SELECT GF80S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

