/**************************************************************************/
/* GF82 ( DBオブジェクト一覧テーブル )                                    */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF82 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID         */
 , TBLSYU    VARCHAR2(1)                  NOT NULL      /* 20  テーブル種別       */
 , OBJ_TYPE  VARCHAR2(20)                 NOT NULL      /* 30  オブジェクトタイプ */
 , OBJ_NAME  VARCHAR2(30)                 NOT NULL      /* 40  オブジェクト名     */
 , NAME_JA   VARCHAR2(120)                              /* 50  名称               */
 , STTS      VARCHAR2(7)                                /* 60  ステータス         */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 70  ユニークキー       */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 80  状態フラグ         */
 , DYSET     VARCHAR2(14)                               /* 90  登録日時           */
 , DYUPD     VARCHAR2(14)                               /* 100 更新日時           */
 , USRSET    VARCHAR2(10)                               /* 110 作成社員           */
 , USRUPD    VARCHAR2(10)                               /* 120 更新者             */
 , PRGUPD    VARCHAR2(10)                               /* 130 更新PRG            */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF82S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF82T01 
BEFORE INSERT ON GF82
FOR EACH ROW 
BEGIN 
SELECT GF82S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

