/**************************************************************************/
/* GF94 ( 項目チェック基準書 )                                            */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF94 (
   SYSTEM_ID  VARCHAR2(10)          /* 10  システムID       */
 , PGID       VARCHAR2(30)          /* 20  プログラムID     */
 , NMSYORI    VARCHAR2(100)         /* 30  処理グループ名   */
 , SEQ        NUMBER(5)             /* 40  表示順           */
 , CLM        VARCHAR2(30)          /* 50  カラム名         */
 , DESC_CHECK VARCHAR2(500)         /* 60  チェック内容     */
 , ERR_NO     VARCHAR2(10)          /* 70  エラー番号       */
 , ERR_MSG    VARCHAR2(1000)        /* 80  エラーメッセージ */
 , UNIQ       NUMBER(9)             /* 90  ユニークキー     */
 , FGJ        VARCHAR2(1)           /* 100 状態フラグ       */
 , DYSET      VARCHAR2(14)          /* 110 登録日時         */
 , DYUPD      VARCHAR2(14)          /* 120 更新日時         */
 , USRSET     VARCHAR2(10)          /* 130 登録者           */
 , USRUPD     VARCHAR2(10)          /* 140 更新者           */
 , PRGUPD     VARCHAR2(10)          /* 150 更新ＰＲＧ       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF94S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF94T01 
BEFORE INSERT ON GF94
FOR EACH ROW 
BEGIN 
SELECT GF94S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

