/**************************************************************************/
/* GF96 ( PG変更履歴 )                                                    */
/*                                                                        */
/* Created : 2009/09/30 19:57:44                                          */
/**************************************************************************/
CREATE TABLE GF96 (
   SYSTEM_ID VARCHAR2(10)          /* 10  システムID   */
 , PGID      VARCHAR2(30)          /* 20  プログラムID */
 , SEQ       NUMBER(5)             /* 30  表示順       */
 , DYHEN     VARCHAR2(8)           /* 40  日付         */
 , RIYU      VARCHAR2(4000)        /* 50  理由         */
 , NAIYO     VARCHAR2(4000)        /* 60  変更内容     */
 , PGSHU     VARCHAR2(10)          /* 70  修正者       */
 , PGKEN     VARCHAR2(10)          /* 80  検証者       */
 , UNIQ      NUMBER(9)             /* 90  ユニークキー */
 , FGJ       VARCHAR2(1)           /* 100 状態フラグ   */
 , DYSET     VARCHAR2(14)          /* 110 登録日時     */
 , DYUPD     VARCHAR2(14)          /* 120 更新日時     */
 , USRSET    VARCHAR2(10)          /* 130 登録者       */
 , USRUPD    VARCHAR2(10)          /* 140 更新者       */
 , PRGUPD    VARCHAR2(10)          /* 150 更新ＰＲＧ   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF96S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF96T01 
BEFORE INSERT ON GF96
FOR EACH ROW 
BEGIN 
SELECT GF96S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

