select
  to_char(s.sid) || decode(s.sid,NULL,NULL,',') || to_char(s.serial#) "SID,SERIAL#",
  s.schemaname SCHEMA,
  s.module MODULE,
  s.action ACTION,
  s.client_info CLIENT_INFO,
  s.process APP_PID,
  p.spid ORACLE_PID,
  s.username ORACLE_USER,
  s.osuser OS_USER,
  s.machine MACHINE_NAME,
  s.program APP_PROGRAM,
  nvl(s.terminal,'NULL') TERMINAL,
  s.server SQLNET,
  last_call_et LAST_CALL,
  status SESSION_STATUS
from v$process p, v$session s
where s.paddr(+) = p.addr
  and s.username not in ('SYS','SYSTEM')
