/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.util.LogWriter;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.resource.CodeData;

public class Selection_CODE
implements Selection {
    private final CodeData codeData;
    private final int[] ADRS;
    private final String CASHE;
    private final int LEN;

    public Selection_CODE(CodeData codeData) {
        this.codeData = codeData;
        int n = this.codeData.getSize();
        this.ADRS = new int[n];
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            bl = !this.codeData.getRawShortLabel(i).equals(this.codeData.getLongLabel(i));
            stringBuilder.append("<option value=\"").append(this.codeData.getCodeKey(i)).append("\"");
            this.ADRS[i] = stringBuilder.length();
            if (bl) {
                stringBuilder.append(" title=\"").append(this.codeData.getLongLabel(i)).append("\"");
            }
            stringBuilder.append(">").append(this.codeData.getRawShortLabel(i)).append("</option>");
        }
        this.CASHE = stringBuilder.toString();
        this.LEN = this.CASHE.length() + 30;
    }

    @Override
    public String getOption(String string, boolean bl) {
        int n = this.codeData.getAddress(string);
        if (n < 0) {
            if (string != null && string.length() > 0) {
                String string2 = "\u30b3\u30fc\u30c9\u306b\u5b58\u5728\u3057\u306a\u3044\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002 Value=[" + string + "]" + HybsSystem.CR + this.codeData;
                LogWriter.log((String)string2);
            }
            return this.CASHE;
        }
        StringBuilder stringBuilder = new StringBuilder(this.LEN);
        if (bl) {
            stringBuilder.append("<option value=\"").append(this.codeData.getCodeKey(n)).append("\"");
        } else {
            stringBuilder.append(this.CASHE.substring(0, this.ADRS[n]));
        }
        stringBuilder.append(" selected=\"selected\"");
        stringBuilder.append(this.CASHE.substring(this.ADRS[n]));
        return stringBuilder.toString();
    }

    @Override
    public String getRadio(String string, String string2, boolean bl) {
        String string3 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string3);
    }

    @Override
    public String getRadioLabel(String string) {
        String string2 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public String getValueLabel(String string) {
        return this.getValueLabel(string, false);
    }

    @Override
    public String getValueLabel(String string, boolean bl) {
        int n = this.codeData.getAddress(string);
        if (n < 0) {
            return string;
        }
        if (bl) {
            return this.codeData.getShortLabel(n);
        }
        return this.codeData.getLongLabel(n);
    }

    @Override
    public boolean useMultiSelect() {
        return this.codeData.useMultiSelect();
    }

    @Override
    public boolean isTimeOver() {
        return false;
    }
}

