/**************************************************************************/
/* GEA04 ( コード定義 )                                                   */
/*                                                                        */
/* Created : 2009/10/02 11:56:26                                          */
/**************************************************************************/
CREATE TABLE GEA04 (
   SYSTEM_ID     VARCHAR2(10)                 NOT NULL      /* 10  システムID       */
 , CLM           VARCHAR2(30)                 NOT NULL      /* 20  項目             */
 , CODE          VARCHAR2(30)                 NOT NULL      /* 30  コード           */
 , SEQNO         NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  表示順           */
 , CDKH          VARCHAR2(1)                                /* 50  改廃コード       */
 , KBSAKU        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 60  作成区分         */
 , UNIQ          NUMBER(9)        DEFAULT 0   NOT NULL      /* 70  ユニークキー     */
 , FGJ           VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 80  状態フラグ       */
 , DYSET         VARCHAR2(14)                               /* 90  登録日時         */
 , DYUPD         VARCHAR2(14)                               /* 100 更新日時         */
 , USRSET        VARCHAR2(10)                               /* 110 作成社員         */
 , USRUPD        VARCHAR2(10)                               /* 120 更新者           */
 , PRGUPD        VARCHAR2(10)                               /* 130 更新PRG          */
 , RELEASE_NOTES VARCHAR2(120)                              /* 140 リリースノート   */
 , RDC_CODE      VARCHAR2(20)                               /* 150 設変番号         */
 , CODEGRP       VARCHAR2(20)                               /* 160 コードグループ   */
 , COMMENTS      VARCHAR2(500)                              /* 170 コメント         */
 , CODELVL       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 180 階層             */
 , CODE_PARAM    VARCHAR2(200)                              /* 190 コードパラメータ */
 , ROLES         VARCHAR2(500)                              /* 200 ロールズ         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GEA04S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GEA04T01 
BEFORE INSERT ON GEA04
FOR EACH ROW 
BEGIN 
SELECT GEA04S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

