/**************************************************************************/
/* GF60 ( オブジェクトマスタ定義 )                                        */
/*                                                                        */
/* Created : 2009/10/02 11:56:28                                          */
/**************************************************************************/
CREATE TABLE GF60 (
   ID     VARCHAR2(30)                 NOT NULL      /* 10  ID           */
 , IDTYPE VARCHAR2(20)                 NOT NULL      /* 20  IDタイプ     */
 , SEQ    NUMBER(5)        DEFAULT 0   NOT NULL      /* 30  順           */
 , FORM   VARCHAR2(20)                 NOT NULL      /* 40  FORM         */
 , NAME   VARCHAR2(200)                              /* 50  名称         */
 , DEF1   VARCHAR2(100)                              /* 60  項目定義１   */
 , DEF2   VARCHAR2(100)                              /* 70  項目定義2    */
 , DEF3   VARCHAR2(100)                              /* 80  項目定義3    */
 , DEF4   VARCHAR2(100)                              /* 90  項目定義4    */
 , DEF5   VARCHAR2(100)                              /* 100 項目定義5    */
 , DEF6   VARCHAR2(100)                              /* 110 項目定義6    */
 , ROLE   VARCHAR2(20)                               /* 120 ロール       */
 , DYKAN  VARCHAR2(8)                                /* 130 完成日       */
 , URL    VARCHAR2(200)                              /* 140 URL          */
 , CDKATU VARCHAR2(1)                                /* 150 活動C        */
 , UNIQ   NUMBER(9)        DEFAULT 0   NOT NULL      /* 160 ユニークキー */
 , FGJ    VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 170 状態フラグ   */
 , DYSET  VARCHAR2(14)                               /* 180 登録日時     */
 , DYUPD  VARCHAR2(14)                               /* 190 更新日時     */
 , USRSET VARCHAR2(10)                               /* 200 作成社員     */
 , USRUPD VARCHAR2(10)                               /* 210 更新者       */
 , PRGUPD VARCHAR2(10)                               /* 220 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF60S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF60T01 
BEFORE INSERT ON GF60
FOR EACH ROW 
BEGIN 
SELECT GF60S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

