/**************************************************************************/
/* GF77 ( タグ検索テーブル )                                              */
/*                                                                        */
/* Created : 2009/10/02 11:56:29                                          */
/**************************************************************************/
CREATE TABLE GF77 (
   SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , ADDRESS   VARCHAR2(256)                               /* 20  アドレス     */
 , FILENAME  VARCHAR2(30)                                /* 30  ファイル名   */
 , FILEPATH  VARCHAR2(256)                               /* 40  ファイルパス */
 , MODIFIED  VARCHAR2(14)                                /* 50  最終更新日   */
 , TAGNAME   VARCHAR2(30)                                /* 60  タグ名称     */
 , VALUELIST VARCHAR2(2000)                              /* 70  タグ属性一覧 */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 80  ユニークキー */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 90  状態フラグ   */
 , DYSET     VARCHAR2(14)                                /* 100 登録日時     */
 , DYUPD     VARCHAR2(14)                                /* 110 更新日時     */
 , USRSET    VARCHAR2(10)                                /* 120 作成社員     */
 , USRUPD    VARCHAR2(10)                                /* 130 更新者       */
 , PRGUPD    VARCHAR2(10)                                /* 140 更新PRG      */
 , FGOMIT    VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 150 除外フラグ   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF77S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF77T01 
BEFORE INSERT ON GF77
FOR EACH ROW 
BEGIN 
SELECT GF77S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

