/**************************************************************************/
/* GF92 ( 画面項目定義テーブル )                                          */
/*                                                                        */
/* Created : 2009/10/02 11:56:29                                          */
/**************************************************************************/
CREATE TABLE GF92 (
   SYSTEM_ID   VARCHAR2(10)         /* 10  システムID     */
 , PGID        VARCHAR2(30)         /* 20  プログラムID   */
 , NMSYORI     VARCHAR2(100)        /* 30  処理グループ名 */
 , SEQ         NUMBER(5)            /* 40  表示順         */
 , CLM         VARCHAR2(30)         /* 50  カラム名       */
 , KBACCS      VARCHAR2(1)          /* 60  アクセス区分   */
 , MUST        VARCHAR2(10)         /* 70  必須           */
 , DEFAULT_VAL VARCHAR2(100)        /* 80  デフォルト値   */
 , TABLE_NAME  VARCHAR2(30)         /* 90  テーブル名     */
 , ZOKUSEI     VARCHAR2(500)        /* 100 属性（桁数）   */
 , SETU        VARCHAR2(500)        /* 110 項目説明       */
 , UNIQ        NUMBER(9)            /* 120 ユニークキー   */
 , FGJ         VARCHAR2(1)          /* 130 状態フラグ     */
 , DYSET       VARCHAR2(14)         /* 140 登録日時       */
 , DYUPD       VARCHAR2(14)         /* 150 更新日時       */
 , USRSET      VARCHAR2(10)         /* 160 登録者         */
 , USRUPD      VARCHAR2(10)         /* 170 更新者         */
 , PRGUPD      VARCHAR2(10)         /* 180 更新ＰＲＧ     */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF92S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF92T01 
BEFORE INSERT ON GF92
FOR EACH ROW 
BEGIN 
SELECT GF92S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

