/**************************************************************************/
/* GF93 ( 画面項目リンク )                                                */
/*                                                                        */
/* Created : 2009/10/02 11:56:29                                          */
/**************************************************************************/
CREATE TABLE GF93 (
   SYSTEM_ID   VARCHAR2(10)         /* 10  システムID       */
 , PGID        VARCHAR2(30)         /* 20  プログラムID     */
 , NMSYORI     VARCHAR2(100)        /* 30  処理グループ名   */
 , SEQ         NUMBER(5)            /* 40  表示順           */
 , CLM         VARCHAR2(30)         /* 50  カラム名         */
 , TO_GAMENID  VARCHAR2(30)         /* 60  飛び先画面ID     */
 , HREF        VARCHAR2(256)        /* 70  飛び先ﾍﾟｰｼﾞ      */
 , TARGET      VARCHAR2(10)         /* 80  ターゲット       */
 , KEYS        VARCHAR2(500)        /* 90  引数キー         */
 , VALS        VARCHAR2(500)        /* 100 引数値           */
 , USEGAMENID  VARCHAR2(10)         /* 110 画面使用         */
 , USEREDIRECT VARCHAR2(10)         /* 120 リダイレクト使用 */
 , UNIQ        NUMBER(9)            /* 130 ユニークキー     */
 , FGJ         VARCHAR2(1)          /* 140 状態フラグ       */
 , DYSET       VARCHAR2(14)         /* 150 登録日時         */
 , DYUPD       VARCHAR2(14)         /* 160 更新日時         */
 , USRSET      VARCHAR2(10)         /* 170 登録者           */
 , USRUPD      VARCHAR2(10)         /* 180 更新者           */
 , PRGUPD      VARCHAR2(10)         /* 190 更新ＰＲＧ       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF93S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF93T01 
BEFORE INSERT ON GF93
FOR EACH ROW 
BEGIN 
SELECT GF93S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

