/**************************************************************************/
/* GF95 ( DBセット基準書 )                                                */
/*                                                                        */
/* Created : 2009/10/02 11:56:29                                          */
/**************************************************************************/
CREATE TABLE GF95 (
   SYSTEM_ID  VARCHAR2(10)         /* 10  システムID     */
 , PGID       VARCHAR2(30)         /* 20  プログラムID   */
 , NMSYORI    VARCHAR2(100)        /* 30  処理グループ名 */
 , SEQ        NUMBER(5)            /* 40  表示順         */
 , TABLE_NAME VARCHAR2(30)         /* 50  テーブル名     */
 , CLM        VARCHAR2(30)         /* 60  カラム名       */
 , MOTO       VARCHAR2(30)         /* 70  入力元         */
 , ADDACT     VARCHAR2(500)        /* 80  追加時         */
 , MODIACT    VARCHAR2(500)        /* 90  更新時         */
 , DELACT     VARCHAR2(500)        /* 100 削除時         */
 , UNIQ       NUMBER(9)            /* 110 ユニークキー   */
 , FGJ        VARCHAR2(1)          /* 120 状態フラグ     */
 , DYSET      VARCHAR2(14)         /* 130 登録日時       */
 , DYUPD      VARCHAR2(14)         /* 140 更新日時       */
 , USRSET     VARCHAR2(10)         /* 150 登録者         */
 , USRUPD     VARCHAR2(10)         /* 160 更新者         */
 , PRGUPD     VARCHAR2(10)         /* 170 更新ＰＲＧ     */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF95S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF95T01 
BEFORE INSERT ON GF95
FOR EACH ROW 
BEGIN 
SELECT GF95S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

