/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.binary.Base64;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileString;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.XHTMLTag;

public class URLConnect {
    private static final String CR = System.getProperty("line.separator");
    private final String urlStr;
    private final String userPass;
    private int rpsCode = -1;
    private String rpsMethod = null;
    private String rpsMessage = null;
    private String type = null;
    private String charset = null;
    private String postData = null;
    private long length = -1L;
    private long date = -1L;
    private long modified = -1L;
    private boolean isPost = false;
    private URLConnection conn = null;
    private Proxy proxy = Proxy.NO_PROXY;

    public URLConnect(String string, String string2) {
        this.urlStr = string;
        this.userPass = string2;
    }

    public void setProxy(String string, int n) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        this.proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        block3: {
            block2: {
                this.conn = this.getConnection();
                if (!this.isPost) break block2;
                this.conn.setDoOutput(true);
                OutputStream outputStream = null;
                PrintStream printStream = null;
                try {
                    outputStream = this.conn.getOutputStream();
                    printStream = new PrintStream(outputStream);
                    printStream.print(this.postData);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(printStream);
                    Closer.ioClose(outputStream);
                    throw throwable;
                }
                Closer.ioClose(printStream);
                Closer.ioClose(outputStream);
                break block3;
            }
            this.conn.connect();
        }
        this.setInfo(this.conn);
    }

    public String readData() throws IOException {
        if (this.conn == null) {
            String string = "connect() \u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u30c7\u30fc\u30bf\u53d6\u5f97\u524d\u306bconnect()\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            throw new RuntimeException(string);
        }
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            bufferedReader = this.getReader();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append(CR);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = "\u6307\u5b9a\u3055\u308c\u305f\u6587\u5b57\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + " url=[" + this.urlStr + "]" + " charset=[" + this.charset + "]";
            throw new RuntimeException(string, unsupportedEncodingException);
        }
        finally {
            Closer.ioClose(bufferedReader);
            this.disconnect();
        }
        return stringBuilder.toString();
    }

    public void disconnect() {
        if (this.conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.conn).disconnect();
        }
    }

    private URLConnection getConnection() throws IOException {
        URL uRL = new URL(this.urlStr);
        URLConnection uRLConnection = uRL.openConnection(this.proxy);
        if (this.userPass != null) {
            byte[] byArray = Base64.encodeBase64((byte[])this.userPass.getBytes());
            String string = new String(byArray);
            uRLConnection.setRequestProperty("Authorization", "Basic " + string);
        }
        return uRLConnection;
    }

    private void setInfo(URLConnection uRLConnection) {
        try {
            this.charset = uRLConnection.getContentEncoding();
            this.type = uRLConnection.getContentType();
            this.length = uRLConnection.getContentLength();
            this.date = uRLConnection.getDate();
            this.modified = uRLConnection.getLastModified();
            if (this.charset == null && this.type != null) {
                int n = this.type.indexOf("charset");
                int n2 = this.type.indexOf(61, n);
                if (n > 0 && n2 > n) {
                    this.charset = this.type.substring(n2 + 1).trim();
                }
            }
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                this.rpsCode = httpURLConnection.getResponseCode();
                this.rpsMethod = httpURLConnection.getRequestMethod();
                this.rpsMessage = httpURLConnection.getResponseMessage() + URLConnect.code2Message(this.rpsCode);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            System.out.println(runtimeException.getMessage());
        }
    }

    public String getUrl() {
        return this.urlStr;
    }

    public void setPostData(String string) {
        this.postData = string;
        if (this.postData != null && "?".indexOf(this.postData) == 0) {
            this.postData = this.postData.substring(1);
        }
        if (this.postData != null) {
            this.isPost = true;
        }
    }

    public String getType() {
        return this.type;
    }

    public long getLength() {
        return this.length;
    }

    public long getDate() {
        return this.date;
    }

    public long getModified() {
        return this.modified;
    }

    public int getCode() {
        return this.rpsCode;
    }

    public String getMethod() {
        return this.rpsMethod;
    }

    public String getMessage() {
        return this.rpsMessage;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public BufferedReader getReader() throws IOException {
        InputStream inputStream = this.conn.getInputStream();
        BufferedReader bufferedReader = this.charset != null ? new BufferedReader(new InputStreamReader(inputStream, this.charset)) : new BufferedReader(new InputStreamReader(inputStream));
        return bufferedReader;
    }

    public static String code2Message(int n) {
        String string;
        switch (n) {
            case 200: {
                string = "200: OK \u3067\u3059\u3002";
                break;
            }
            case 201: {
                string = "201: \u4f5c\u6210\u3055\u308c\u307e\u3057\u305f\u3002";
                break;
            }
            case 202: {
                string = "202: \u8a31\u53ef\u3055\u308c\u307e\u3057\u305f\u3002";
                break;
            }
            case 203: {
                string = "203: \u4e0d\u5f53\u306a\u60c5\u5831\u3067\u3059\u3002";
                break;
            }
            case 204: {
                string = "204: \u30b3\u30f3\u30c6\u30f3\u30c4\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
                break;
            }
            case 205: {
                string = "205: \u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059\u3002";
                break;
            }
            case 206: {
                string = "206: \u90e8\u5206\u7684\u306a\u30b3\u30f3\u30c6\u30f3\u30c4\u3067\u3059\u3002";
                break;
            }
            case 300: {
                string = "300: \u8907\u6570\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
                break;
            }
            case 301: {
                string = "301: \u6c38\u7d9a\u7684\u306b\u79fb\u52d5\u3055\u308c\u307e\u3057\u305f\u3002";
                break;
            }
            case 302: {
                string = "302: \u4e00\u6642\u7684\u306b\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
                break;
            }
            case 303: {
                string = "303: \u4ed6\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                break;
            }
            case 304: {
                string = "304: \u4fee\u6b63\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                break;
            }
            case 305: {
                string = "305: \u30d7\u30ed\u30ad\u30b7\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                break;
            }
            case 400: {
                string = "400: \u4e0d\u5f53\u306a\u8981\u6c42\u3067\u3059\u3002";
                break;
            }
            case 401: {
                string = "401: \u8a8d\u8a3c\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                break;
            }
            case 402: {
                string = "402: \u652f\u6255\u3044\u304c\u5fc5\u8981\u3067\u3059\u3002";
                break;
            }
            case 403: {
                string = "403: \u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
                break;
            }
            case 404: {
                string = "404: \u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                break;
            }
            case 405: {
                string = "405: \u30e1\u30bd\u30c3\u30c9\u306f\u8a31\u53ef\u3055\u308c\u307e\u305b\u3093\u3002";
                break;
            }
            case 406: {
                string = "406: \u8a31\u5bb9\u3055\u308c\u307e\u305b\u3093\u3002";
                break;
            }
            case 407: {
                string = "407: \u30d7\u30ed\u30ad\u30b7\u306e\u8a8d\u8a3c\u304c\u5fc5\u8981\u3067\u3059\u3002";
                break;
            }
            case 408: {
                string = "408: \u8981\u6c42\u304c\u6642\u9593\u5207\u308c\u3067\u3059\u3002";
                break;
            }
            case 409: {
                string = "409: \u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002";
                break;
            }
            case 410: {
                string = "410: \u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
                break;
            }
            case 411: {
                string = "411: \u9577\u3055\u304c\u5fc5\u8981\u3067\u3059\u3002";
                break;
            }
            case 412: {
                string = "412: \u524d\u63d0\u6761\u4ef6\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002";
                break;
            }
            case 413: {
                string = "413: \u8981\u6c42\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u304c\u9577\u3059\u304e\u307e\u3059\u3002";
                break;
            }
            case 414: {
                string = "414: \u8981\u6c42 URL \u304c\u9577\u3059\u304e\u307e\u3059\u3002";
                break;
            }
            case 415: {
                string = "415: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u306a\u3044\u30e1\u30c7\u30a3\u30a2\u30bf\u30a4\u30d7\u3067\u3059\u3002";
                break;
            }
            case 500: {
                string = "500: \u5185\u90e8\u30b5\u30fc\u30d0\u30a8\u30e9\u30fc\u3067\u3059\u3002";
                break;
            }
            case 501: {
                string = "501: \u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
                break;
            }
            case 502: {
                string = "502: \u8aa4\u3063\u305f\u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u3067\u3059\u3002";
                break;
            }
            case 503: {
                string = "503: \u30b5\u30fc\u30d3\u30b9\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
                break;
            }
            case 504: {
                string = "504: \u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u304c\u6642\u9593\u5207\u308c\u3067\u3059\u3002";
                break;
            }
            case 505: {
                string = "505: HTTP \u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
                break;
            }
            default: {
                string = "-1: \u672a\u5b9a\u7fa9";
            }
        }
        return string;
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        String string;
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.URLConnect [<-info/-data>] <url> [user:passwd]");
            LogWriter.log("   args[*] : [<-info/-data>]      \u60c5\u5831\u306e\u53d6\u5f97\u304b\u3001\u30c7\u30fc\u30bf\u306e\u53d6\u5f97\u304b\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:-data)\u3002");
            LogWriter.log("   args[*] : [<-post=\u30d5\u30a1\u30a4\u30eb\u540d>] POST\u30e1\u30bd\u30c3\u30c9\u3092\u6307\u5b9a\u3057\u3066\u3001\u30d5\u30a1\u30a4\u30eb\u30c7\u30fc\u30bf\u3092\u9001\u4fe1\u3057\u307e\u3059\u3002(\u521d\u671f\u5024:-get)\u3002");
            LogWriter.log("   args[*] : [<-encode=UTF-8>]    \u30a8\u30f3\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002(\u901a\u5e38\u306f\u63a5\u7d9a\u5148\u306eencode\u3092\u4f7f\u7528)");
            LogWriter.log("   args[*] : [<-out=\u30d5\u30a1\u30a4\u30eb\u540d>]  \u7d50\u679c\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u51fa\u529b\u3057\u307e\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u30a8\u30f3\u30b3\u30fc\u30c9\u3082\u6307\u5b9a\u3057\u307e\u3059\u3002");
            LogWriter.log("   args[A] : <url>                \uff35\uff32\uff2c\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002GET\u306e\u5834\u5408\u3001\u30d1\u30e9\u30e1\u30fc\u30bf\u306f ?KEY=VAL\u3067\u3059\u3002");
            LogWriter.log("   args[B] : [<user:passwd>]      BASIC\u8a8d\u8a3c\u306e\u30a8\u30ea\u30a2\u3078\u306e\u30a2\u30af\u30bb\u30b9\u6642\u306b\u6307\u5b9a\u3057\u307e\u3059\u3002");
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray2 = new String[2];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if (string.equalsIgnoreCase("-info")) {
                bl = true;
                continue;
            }
            if (string.equalsIgnoreCase("-data")) {
                bl = false;
                continue;
            }
            if (string.startsWith("-post=")) {
                bl2 = true;
                int n2 = string.indexOf(58, 6);
                string2 = string.substring(6, n2);
                string3 = string.substring(n2 + 1);
                continue;
            }
            if (string.startsWith("-encode=")) {
                string5 = string.substring(8);
                continue;
            }
            if (string.startsWith("-out=")) {
                string4 = string.substring(5);
                continue;
            }
            if (string.startsWith("-")) {
                System.out.println("Error Argment:" + string);
                continue;
            }
            stringArray2[n++] = string;
        }
        String string6 = stringArray2[0];
        string = stringArray2[1];
        URLConnect uRLConnect = new URLConnect(string6, string);
        if (bl2) {
            object = new FileString();
            ((FileString)object).setFilename(string3);
            String string7 = ((FileString)object).getValue();
            uRLConnect.setPostData(XHTMLTag.urlEncode(string2, string7));
        }
        uRLConnect.connect();
        if (string5 != null) {
            uRLConnect.setCharset(string5);
        } else {
            string5 = uRLConnect.getCharset();
        }
        object = string4 != null ? FileUtil.getPrintWriter(new File(string4), string5) : FileUtil.getLogWriter("System.out");
        if (bl) {
            ((PrintWriter)object).println("URL    :" + uRLConnect.getUrl());
            ((PrintWriter)object).println("Type   :" + uRLConnect.getType());
            ((PrintWriter)object).println("Code   :" + uRLConnect.getCode());
            ((PrintWriter)object).println("Message:" + uRLConnect.getMessage());
            ((PrintWriter)object).println("Charset:" + uRLConnect.getCharset());
        } else {
            ((PrintWriter)object).println(uRLConnect.readData());
        }
        uRLConnect.disconnect();
        Closer.ioClose((Closeable)object);
    }
}

