/**************************************************************************/
/* GE32 ( 送信履歴テーブル )                                              */
/*                                                                        */
/* Created : 2009/11/04 19:23:38                                          */
/**************************************************************************/
CREATE TABLE GE32 (
   YKNO      NUMBER(9)         DEFAULT 0   NOT NULL      /* 10  要求ＮＯ       */
 , PARA_KEY  VARCHAR2(9)                                 /* 20  パラメータキー */
 , PTN_ID    VARCHAR2(20)                                /* 30  定型文ID       */
 , SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 40  システムID     */
 , FROM_ADDR VARCHAR2(100)                 NOT NULL      /* 50  送信元         */
 , TITLE     VARCHAR2(300)                               /* 60  タイトル       */
 , CONTENT   VARCHAR2(4000)                              /* 70  内容           */
 , ATTACH1   VARCHAR2(256)                               /* 80  添付１         */
 , ATTACH2   VARCHAR2(256)                               /* 90  添付２         */
 , ATTACH3   VARCHAR2(256)                               /* 100 添付３         */
 , ATTACH4   VARCHAR2(256)                               /* 110 添付４         */
 , ATTACH5   VARCHAR2(256)                               /* 120 添付５         */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 130 ユニークキー   */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 140 状態フラグ     */
 , DYSET     VARCHAR2(14)                                /* 150 登録日時       */
 , DYUPD     VARCHAR2(14)                                /* 160 更新日時       */
 , USRSET    VARCHAR2(10)                                /* 170 作成社員       */
 , USRUPD    VARCHAR2(10)                                /* 180 更新者         */
 , PRGUPD    VARCHAR2(10)                                /* 190 更新PRG        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE32S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE32T01 
BEFORE INSERT ON GE32
FOR EACH ROW 
BEGIN 
SELECT GE32S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

