<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0002"
	title    = "画面"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,GUIKEY,NAME,LONGNAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@FROMGUIKEY}" nullCheck="true" notEquals="true">
	<og:value command="SQL">
		<og:text>
			SELECT SEQNO AS FROMKEY FROM GEA11 WHERE GUIKEY = '{@FROMGUIKEY}' AND SYSTEM_ID = '{@SYSTEM_ID}' AND FGJ = '1'
		</og:text>
	</og:value>
	<og:value command="SQL">
		<og:text>
			SELECT COALESCE ( MIN(SEQNO), 999999 ) AS TOKEY FROM GEA11 WHERE SEQNO &gt; '{@FROMKEY}' AND GUILVL &lt;= '{@GUILVL}' AND SYSTEM_ID = '{@SYSTEM_ID}' AND FGJ = '1'
		</og:text>
	</og:value>
</og:equals>

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select
		'1' as WRITABLE,A.GUIKEY,A.ADDRESS,A.SEQNO,A.GUILVL,A.LABEL_CLM,A.GROUPS,
		A.NAME_JA,'' LNAME,'' SNAME,A.ROLES,
		A.RWMODE,A.KBLINK,A.TARGET,A.PARAM,'' DESCRIPTION,A.COMMENTS,'ja' LANG,A.SYSTEM_ID,A.KBSAKU,
		A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,A.UNIQ,'' CLM,'0' EXIST_GEA08,0 UNIQ_GEA08
		from GEA11 A
		where A.SYSTEM_ID IN ( '{@SYSTEM_ID}','{@AST}' )
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.FGJ           =    '{@FGJ}'"            />
		<og:and value = "UPPER(A.GUIKEY) like UPPER('{@GUIKEY}%')" />
		<og:and value = "A.NAME_JA       like '{@NAME_JA}%'"       />
		<og:and value = "A.ROLES         like '{@ROLES}%'"         />
		<og:and value = "A.KBSAKU        =    '{@KBSAKU}'"         />
		<og:and value = "A.RDC_CODE      =    '{@RDC_CODE}'"       />
		<og:and value = "A.DYUPD     &gt;=    '{@DYUPDFROM}'"      />
		<og:and value = "A.DYUPD     &lt;=    '{@DYUPDTO}99'"      />
		<og:and value = "A.RELEASE_NOTES like '{@RELEASE_NOTES}%'" />
		<og:and value = "A.USRUPD        =    '{@USRUPD}'"         />
		<og:and value = "A.CDKH {@CDKH}" />
		<og:and value = "A.SEQNO BETWEEN {@FROMKEY} and {@TOKEY} - 1 " />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SEQNO,A.GUIKEY,A.ADDRESS,A.SYSTEM_ID DESC,A.KBSAKU DESC" />
</og:query>

<og:tableMerge
	action        = "GROUP"
	masterKeys    = "GUIKEY,ADDRESS"
	display       = "false"
/>

<og:value command="SET" key="LABEL_SQL">
	select A.LNAME, A.SNAME, A.DESCRIPTION, A.LANG
	from GEA08 A
	where A.SYSTEM_ID in ( '{@SYSTEM_ID}','**' )
	and A.CLM = [GUIKEY]
	<og:where startKey="and">
		<og:and value = "A.LNAME        like '{@LNAME}%'"       />
		<og:and value = "A.SNAME        like '{@SNAME}%'"       />
		<og:and value = "A.LANG         =    '{@LANG}'"         />
	<og:and value = "A.FGJ          =    '{@FGJ}'"          />
	</og:where>
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC
</og:value>

<og:equals val1="{@LNAME}{@SNAME}" nullCheck="true" notEquals="true">
	<og:value command="SET" key="INNER_JOIN" value="true" />
</og:equals>
<og:tableFilter classId="DBSELECT" dbid="{@FROM_DBID}" selectedAll="true" keys="INNER_JOIN" vals="{@INNER_JOIN}" >
	{@LABEL_SQL}
</og:tableFilter>

<og:columnEditor columns="SYSTEM_ID,GUIKEY,SEQNO,GUILVL,RWMODE" must="true" />

<og:viewMarker isRenderer="false"  command="NEW">
	<og:columnMarker column="ROLES" onMark="true">
	[ROLES]<img style="cursor:pointer;" src="{@SYS.JSP}/image/multiChoose.gif"
				onClick="ogOpen('{@SYS.JSP}/custom/multiChoose.jsp?name=ROLES&amp;SYSTEM_ID={@SYSTEM_ID}&amp;editor=DBMENU&amp;param=select ROLE,NMROLE from GEA05 where SYSTEM_ID=\\'{@SYSTEM_ID}\\' and KBROLE=\\'1\\' and FGJ=\\'1\\'', event,'ROLES__[I]','width=500,height=200,resizable=no' );" />
	</og:columnMarker>
	<og:columnMarker column="GROUPS" onMark="true">
	[GROUPS]<img style="cursor:pointer;" src="{@SYS.JSP}/image/multiChoose.gif" onClick="ogOpen('{@SYS.JSP}/custom/multiChoose.jsp?name=GROUPS&amp;separator=,&amp;SYSTEM_ID={@SYSTEM_ID}', event,'GROUPS__[I]','width=500,height=200,resizable=no' );" />
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<og:link column="GUIKEY" gamenId="GE0005" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG"
		vals="NEW,[SYSTEM_ID],[GUIKEY],1,[LANG]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals="null" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"SYSTEM_ID,GUIKEY,KBSAKU,RDC_CODE,CDKH"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable,logicalDelete" vals="null,true" />
	<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
		keys="columnWritable" vals="null" />
	<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA11" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  value="update" lbl="COPY" command="COPY"
				keys="noWritable,sysins" vals="null,true" />
		</fieldset>
	</og:equals>
	<br />
</og:writeCheck>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
		<jsp:text>{@USER.LASTSQL}</jsp:text>
	</og:query>
	<og:tableFilter classId="DBSELECT" scope="request" dbid="{@TO_DBID}" selectedAll="true" keys="INNER_JOIN" vals="{@INNER_JOIN}" >
		{@LABEL_SQL}
	</og:tableFilter>

	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,GUIKEY,ROLES,KBSAKU"
		diffKeys      = "SEQNO,NAME_JA,GUILVL,ADDRESS,RWMODE,KBLINK,TARGET,PARAM,GROUPS,LABEL_CLM,LNAME,SNAME"
		slaveScope    = "request"
		modifyClms    = "UNIQ,UNIQ_GEA08"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}"
	noDisplay    = "UNIQ,CLM,EXIST_GEA08,UNIQ_GEA08"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"  />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
