/**************************************************************************/
/* GEA11 ( 画面定義 )                                                     */
/*                                                                        */
/* Created : 2009/11/04 19:23:38                                          */
/**************************************************************************/
CREATE TABLE GEA11 (
   SYSTEM_ID     VARCHAR2(10)                 NOT NULL      /* 10  システムID     */
 , SEQNO         NUMBER(7)        DEFAULT 0   NOT NULL      /* 20  表示順         */
 , GUIKEY        VARCHAR2(30)                 NOT NULL      /* 30  画面ID         */
 , NAME_JA       VARCHAR2(120)                              /* 40  名称           */
 , GUILVL        VARCHAR2(1)      DEFAULT '3' NOT NULL      /* 50  画面Lv         */
 , ADDRESS       VARCHAR2(256)                              /* 60  アドレス       */
 , ROLES         VARCHAR2(500)                              /* 70  ロールズ       */
 , RWMODE        VARCHAR2(3)                                /* 80  モード         */
 , TARGET        VARCHAR2(10)                               /* 90  ターゲット     */
 , PARAM         VARCHAR2(500)                              /* 100 設定値         */
 , CDKH          VARCHAR2(1)                                /* 110 改廃コード     */
 , KBSAKU        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 120 作成区分       */
 , UNIQ          NUMBER(9)        DEFAULT 0   NOT NULL      /* 130 ユニークキー   */
 , FGJ           VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 140 状態フラグ     */
 , DYSET         VARCHAR2(14)                               /* 150 登録日時       */
 , DYUPD         VARCHAR2(14)                               /* 160 更新日時       */
 , USRSET        VARCHAR2(10)                               /* 170 作成社員       */
 , USRUPD        VARCHAR2(10)                               /* 180 更新者         */
 , PRGUPD        VARCHAR2(10)                               /* 190 更新PRG        */
 , RELEASE_NOTES VARCHAR2(120)                              /* 200 リリースノート */
 , RDC_CODE      VARCHAR2(20)                               /* 210 設変番号       */
 , GROUPS        VARCHAR2(500)                              /* 220 グループス     */
 , LABEL_CLM     VARCHAR2(30)                               /* 230 ラベルカラム   */
 , COMMENTS      VARCHAR2(500)                              /* 240 コメント       */
 , KBLINK        VARCHAR2(10)                               /* 250 リンク区分     */
)
TABLESPACE GETBL01
STORAGE( INITIAL 192K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GEA11S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GEA11T01 
BEFORE INSERT ON GEA11
FOR EACH ROW 
BEGIN 
SELECT GEA11S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

