/**************************************************************************/
/* GF01 ( テーブルスペース定義 )                                          */
/*                                                                        */
/* Created : 2009/11/04 19:23:39                                          */
/**************************************************************************/
CREATE TABLE GF01 (
   SYSTEM_ID       VARCHAR2(10)                 NOT NULL      /* 10  システムID           */
 , TBLSYU          VARCHAR2(1)                  NOT NULL      /* 20  テーブル種別         */
 , TABLESPACE_NAME VARCHAR2(30)                 NOT NULL      /* 30  テーブルスペース名   */
 , NAME_JA         VARCHAR2(120)                              /* 40  名称                 */
 , FILE_NAME       VARCHAR2(500)                              /* 50  ファイル名称         */
 , SIZE_AUTO       NUMBER(10)       DEFAULT 0   NOT NULL      /* 60  自動計算データサイズ */
 , SIZE_DATA       NUMBER(10)       DEFAULT 5   NOT NULL      /* 70  データサイズ(MB)     */
 , STATUS          VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 80  ステータス           */
 , UNIQ            NUMBER(9)        DEFAULT 0   NOT NULL      /* 90  ユニークキー         */
 , FGJ             VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 100 状態フラグ           */
 , DYSET           VARCHAR2(14)                               /* 110 登録日時             */
 , DYUPD           VARCHAR2(14)                               /* 120 更新日時             */
 , USRSET          VARCHAR2(10)                               /* 130 作成社員             */
 , USRUPD          VARCHAR2(10)                               /* 140 更新者               */
 , PRGUPD          VARCHAR2(10)                               /* 150 更新PRG              */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF01S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF01T01 
BEFORE INSERT ON GF01
FOR EACH ROW 
BEGIN 
SELECT GF01S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

