/**************************************************************************/
/* GF22 ( ＴＡＧＬＩＢ属性定義 )                                          */
/*                                                                        */
/* Created : 2009/11/04 19:23:39                                          */
/**************************************************************************/
CREATE TABLE GF22 (
   VERSION     VARCHAR2(10)                 NOT NULL      /* 10  バージョン   */
 , PREFIX      VARCHAR2(10)                 NOT NULL      /* 20  名前空間     */
 , TAGNAME     VARCHAR2(30)                 NOT NULL      /* 30  タグ名称     */
 , VALUENAME   VARCHAR2(30)                 NOT NULL      /* 40  属性名称     */
 , SEQ         NUMBER(5)        DEFAULT 0   NOT NULL      /* 50  順           */
 , TAGCLASS    VARCHAR2(100)                NOT NULL      /* 60  TAGクラス名  */
 , REQUIRED    VARCHAR2(1)                                /* 70  必須         */
 , RTEXPRVALUE VARCHAR2(1)                                /* 80  動的計算属性 */
 , TYPE        VARCHAR2(100)                              /* 90  TYPE         */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 100 ユニークキー */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 110 状態フラグ   */
 , DYSET       VARCHAR2(14)                               /* 120 登録日時     */
 , DYUPD       VARCHAR2(14)                               /* 130 更新日時     */
 , USRSET      VARCHAR2(10)                               /* 140 作成社員     */
 , USRUPD      VARCHAR2(10)                               /* 150 更新者       */
 , PRGUPD      VARCHAR2(10)                               /* 160 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 5120K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF22S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF22T01 
BEFORE INSERT ON GF22
FOR EACH ROW 
BEGIN 
SELECT GF22S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

