/**************************************************************************/
/* GF71 ( 画面関連状態テーブル )                                          */
/*                                                                        */
/* Created : 2009/11/04 19:23:40                                          */
/**************************************************************************/
CREATE TABLE GF71 (
   SYSTEM_ID   VARCHAR2(10)                 NOT NULL      /* 10  システムID       */
 , ADDRESS     VARCHAR2(256)                              /* 20  アドレス         */
 , FILENAME    VARCHAR2(30)                               /* 30  ファイル名       */
 , FILEPATH    VARCHAR2(256)                              /* 40  ファイルパス     */
 , MODIFIED    VARCHAR2(14)                               /* 50  最終更新日       */
 , TAGNAME     VARCHAR2(30)                               /* 60  タグ名称         */
 , TO_GAMENID  VARCHAR2(30)                               /* 70  先画面ID         */
 , HREF        VARCHAR2(256)                              /* 80  リンク先URL      */
 , TARGET      VARCHAR2(10)                               /* 90  ターゲット       */
 , CLM         VARCHAR2(30)                               /* 100 項目             */
 , KEYS        VARCHAR2(500)                              /* 110 引数キー         */
 , VALS        VARCHAR2(500)                              /* 120 引数値           */
 , USEGAMENID  VARCHAR2(10)                               /* 130 画面使用         */
 , USEREDIRECT VARCHAR2(10)                               /* 140 リダイレクト使用 */
 , TEXT        CLOB                                       /* 150 テキスト         */
 , FGOMIT      VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 160 除外フラグ       */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 170 ユニークキー     */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 180 状態フラグ       */
 , DYSET       VARCHAR2(14)                               /* 190 登録日時         */
 , DYUPD       VARCHAR2(14)                               /* 200 更新日時         */
 , USRSET      VARCHAR2(10)                               /* 210 作成社員         */
 , USRUPD      VARCHAR2(10)                               /* 220 更新者           */
 , PRGUPD      VARCHAR2(10)                               /* 230 更新PRG          */
)
TABLESPACE GETBL01
STORAGE( INITIAL 576K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF71S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF71T01 
BEFORE INSERT ON GF71
FOR EACH ROW 
BEGIN 
SELECT GF71S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

