<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC19"
	title	= "作成区分メンテ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   	= "{@command}"
	minRowCount	= "1"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<!-- カラムをアップデートします -->
<og:tableUpdate
	command		= "{@command}"
	queryType	= "JDBCTableUpdate">
	<og:text>
		UPDATE	GEA03 A
		SET		KBSAKU			= '0'
		WHERE	EXISTS ( SELECT 'x' FROM GF79 B
						 WHERE	B.SOURCE		= [SOURCE]
						 AND 	B.SYSTEM_ID 	= '{@MEM.SYSTEM_ID}'
						 AND	A.CLM			= B.NAME )
		AND		A.FGJ			= '1'
		AND		A.SYSTEM_ID 	= '{@MEM.SYSTEM_ID}'
		AND		A.KBSAKU		!= '0'
	</og:text>
</og:tableUpdate>

<!-- コードをアップデートします -->
<og:tableUpdate
	command		= "{@command}"
	queryType	= "JDBCTableUpdate">
	<og:text>
		UPDATE	GEA04 A
		SET		KBSAKU			= '0'
		WHERE	EXISTS( SELECT 'x' FROM GF79 B
						WHERE	B.SOURCE 		= [SOURCE]
						AND 	B.SYSTEM_ID 	= '{@MEM.SYSTEM_ID}'
						AND		A.CLM			= B.NAME )
		AND		A.FGJ			= '1'
		AND		A.SYSTEM_ID 	= '{@MEM.SYSTEM_ID}'
		AND		A.KBSAKU		!= '0'
	</og:text>
</og:tableUpdate>

<!-- ラベルをアップデートします -->
<!-- コードラベルの用のlikeのためにEXISTSを利用します -->
<!-- 縦棒連結を行っているためそのままではSQLサーバで動作しない -->
<og:tableUpdate
	command		= "{@command}"
	queryType	= "JDBCTableUpdate">
	<og:text>
		UPDATE	GEA08 A
		SET		KBSAKU			= '0'
		WHERE	EXISTS ( SELECT 'x' FROM GF79 B
						 WHERE ( B.NAME		= A.CLM OR B.NAME LIKE ( A.CLM || '.%' ) )
						 AND B.SOURCE		= [SOURCE]
						 AND B.SYSTEM_ID	= '{@MEM.SYSTEM_ID}' )
		AND		A.FGJ			= '1'
		AND		A.SYSTEM_ID		= '{@MEM.SYSTEM_ID}'
		AND		A.KBSAKU		!= '0'
	</og:text>
</og:tableUpdate>

<!-- 複雑になるので、画面のラベルのみ別処理に分ける -->
<!-- JSPが元ネタかどうかはリソース区分で見る -->
<og:tableUpdate
	command		= "{@command}"
	queryType	= "JDBCTableUpdate">
	<og:text>
		UPDATE	GEA08 A
		SET		KBSAKU			= '0'
		WHERE	EXISTS ( SELECT 'x' FROM GF79 B 
						 WHERE EXISTS ( SELECT 'x' FROM GEA11 C
										WHERE	C.ADDRESS	= [SOURCE]
										AND		C.GUIKEY 	= A.CLM)
						 AND B.SOURCE		= [SOURCE]
						 AND B.KBRSC		IN ('0','1')
						 AND B.SYSTEM_ID	= '{@MEM.SYSTEM_ID}' )
		AND		A.FGJ			= '1'
		AND		A.SYSTEM_ID		= '{@MEM.SYSTEM_ID}'
		AND		A.KBSAKU		!= '0'
	</og:text>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
