<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6090"
	title	= "棒グラフ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select BRANCH,
			SUM(SALES)/50000 AS SALES1,SUM(SALES) AS SALES,
			SUM(AMOUNT)/50000 AS AMOUNT1,SUM(AMOUNT) AS AMOUNT,
			ABS(SUM(SALES-AMOUNT))/5000 AS PROFIT1,SUM(SALES-AMOUNT) AS PROFIT,
			rtrim(CASE WHEN SUM(SALES-AMOUNT) &lt; 0 THEN '0' ELSE '1' END) AS SIGN
		from GF43
	</jsp:text>
	<og:where>
		<og:and value = "YEAR    = '{@YEAR}'"   />
		<og:and value = "BLOCK   = '{@BLOCK}'"  />
	</og:where>
	<jsp:text>
		group by BRANCH
	</jsp:text>
	<og:appear startKey = "order by" value = "{@ORDER_BY}" 
				defaultVal = "SALES1 DESC" />
</og:query>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}"
	rowspan    = "2"
	headerSkipCount = "0"
>
	<og:thead rowspan="2">
		<tr>
			<td rowspan="2">[BRANCH]</td>
			<td colspan="2">[SALES]</td>
			<td  rowspan="2" colspan="2">[PROFIT]</td>
		</tr><tr>
			<td colspan="2">[AMOUNT]</td>
		</tr>
	</og:thead>

	<og:tbody usableKey="SIGN" usableList="1" rowspan="2">
		<tr>
			<td rowspan="2">[BRANCH]</td>
			<td>[SALES]</td><td><img width="[SALES1]px"  align="left" height="10px" src="{@SYS.JSP}/image/space_green.gif" alt="[SALES1]"  /></td>
			<td colspan="2">[PROFIT]</td>
		</tr><tr>
			<td>[AMOUNT]</td><td><img width="[AMOUNT1]px" align="left" height="10px" src="{@SYS.JSP}/image/space_blue.gif"  alt="[AMOUNT1]" /></td>
			<td></td><td><img width="[PROFIT1]px" align="left" height="10px" src="{@SYS.JSP}/image/space_brown.gif"   alt="[PROFIT1]" /></td>
		</tr>
	</og:tbody>

	<og:tbody usableKey="SIGN" usableList="0" rowspan="2" >
		<tr>
			<td rowspan="3">[BRANCH]</td>
			<td>[SALES]</td><td><img width="[SALES1]px"  align="left" height="10px" src="{@SYS.JSP}/image/space_green.gif" alt="[SALES1]"  /></td>
			<td colspan="2">[PROFIT]</td>
		</tr><tr>
			<td>[AMOUNT]</td><td><img width="[AMOUNT1]px" align="left" height="10px" src="{@SYS.JSP}/image/space_blue.gif"  alt="[AMOUNT1]" /></td>
			<td><img width="[PROFIT1]px" align="right" height="10px" src="{@SYS.JSP}/image/space_red.gif" alt="[PROFIT1]" /></td><td></td>
		</tr>
	</og:tbody>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
