﻿<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<!-- 画面遷移なしを有効にします -->
<og:head headType="result" noTransition="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9130"
	title	= "特殊(遷移なし)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select CLM,NAME_JA,LABEL_NAME,URL,KBSAKU,
				SYSTEM_ID,LANG,FGJ,(CASE WHEN URL IS NULL THEN 0 ELSE 1 END) AS ONMARK
		from GF41
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"  />
		<og:and value = "LANG        = '{@LANG}'"           />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}%'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor column="LANG"      must="true" />
<og:columnEditor column="CLM"       must="true" size="20" />
<og:columnEditor column="NAME_JA"     size="20" />
<og:columnEditor column="LABEL_NAME"  size="20" />

<!-- 画面遷移なしモードで登録を行うため、formのidを"noTransition"とします。-->
<!-- idが指定されていない場合は、1番目のformに対して動的入力モードが適用されます。 -->
<form method="POST" action="forward.jsp" target="RESULT" id="noTransition">

<!-- 画面遷移なしモードでは、登録ボタンも合わせて表示します -->
<og:writeCheck>
	<fieldset style="display:inline; padding: 5px">
		<legend><strong><og:message lbl="ROW_OPERATION" /></strong></legend>
		<og:submit value="update" command="COPY"  lbl="COPY"   accesskey="C"
			keys="columnWritable" vals='"SYSTEM_ID,LANG,KBSAKU,CLM,LABEL_NAME,URL,NAME_JA"' />				<!--複写(C)-->
		<og:submit value="update" command="MODIFY" lbl="MODIFY"  accesskey="M"
			keys="columnWritable" vals='"KBSAKU,LABEL_NAME,URL,NAME_JA"' />									<!--変更(M)-->
		<og:submit value="update" command="DELETE" lbl="DELETE"  accesskey="D" />							<!--削除(D)-->
		<og:submit value="undo" lbl="UNDO" accesskey="U" onClick="return confirm('{@LBL.MSG0048}');"/>		<!--取消(R)-->
	</fieldset>

	<fieldset style="display:inline; padding: 5px; margin-left: 10px;">
		<legend><strong><og:message lbl="DATA_REGISTRATION" /></strong></legend>
		<og:submit value="entry"  lbl="ENTRY"  accesskey="E" />								<!--登録(E)-->
	</fieldset>
</og:writeCheck>

<!-- 画面遷移なしモードでは、追加行がDBTableModelの行の最後に追加されるため、 -->
<!-- 再検索時の行選択機能が現状ではうまく動作しません -->
<og:view
	viewFormType	= "HTMLTable"
	command			= "{@command}"
	noDisplay		= "FGJ,ONMARK" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
