select
 drs.segment_name,
 drs.tablespace_name,
 decode(vrs.status,null,drs.status,vrs.status)  STATUS,
 ds.bytes/1024/1024 MB,
 drs.initial_extent/1024/1024    INITIAL_EXTENT_MB,
 drs.next_extent/1024/1024       NEXT_EXTENT_MB,
 ds.extents,
 drs.min_extents,
 drs.max_extents,
 vrs.optsize/1024/1024           OPTSIZE_MB,
 vrs.shrinks,
 vrs.xacts,
 vrs.writes/1024/1024            WRITE_MB,
 vrs.gets,
 vrs.waits,
 ((vrs.gets-vrs.waits)*100)/vrs.gets GET_RATIO
from
 dba_rollback_segs  drs , 
 dba_segments       ds ,  
 v$rollstat         vrs
where
 drs.segment_name = ds.segment_name
 and   vrs.usn(+) = drs.segment_id
 and   ds.segment_type like '%ROLL%'
order by 1
