/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.db;

import java.sql.SQLData;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLException;

/**
 * SQLData インターフェースを継承した システム変数の受け渡し用オブジェクトです。
 * 行番号情報と改廃コード（ A:追加 C:変更 D:削除 ) を持っています。
 *
 * @og.group ＤＢ/Shell制御
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class DBSysArg implements SQLData {
	private String sql_type ;

	private int    lineNo;
	private String codeKaihai;
	private String curdate;		// 4.3.0.0 (2008/07/22)
	private String pgid;		// 4.3.0.0 (2008/07/22)
	private String userid;		// 4.3.0.0 (2008/07/22)

	/**
	 *  デフォルトコンストラクター
	 */
	public DBSysArg() {
		sql_type   = null;
		lineNo     = -1;
		codeKaihai = null;
		curdate    = null;
		pgid       = null;
		userid     = null;
	}

	/**
	 * すべての属性情報を指定して、新しい DBSysArg オブジェクトを作成します。
	 * 
	 * @og.rev 4.3.0.0 (2008/07/22) 引数に日付、PG、ユーザーIDを追加
	 *
	 * @param    type データベースタイプ文字列
	 * @param    no 行番号
	 * @param    cdkh 改廃コード A:追加 C:変更 D:削除
	 */
//	public DBSysArg( final String type,final int no,final String cdkh ) {
	public DBSysArg( final String type,final int no,final String cdkh, final String time, final String pg, final String user ) {
		sql_type   = type;
		lineNo     = no;
		codeKaihai = cdkh;
		curdate    = time;
		pgid       = pg;
		userid     = user;
	}

	// ============================================================
	// implements SQLData
	// ============================================================

	/**
	 *  ＳＱＬタイプの文字列を返します。
	 *
	 * @return    ＳＱＬタイプの文字列
	 * @throws SQLException
	 */
	public String getSQLTypeName() throws SQLException {
		return sql_type;
	}

	/**
	 *  データベース内部より内部属性を取得し、オブジェクトを構築します。
	 *  
	 * @og.rev 4.3.0.0 (2008/07/22) 日付、PG、ユーザーIDを追加
	 *
	 * @param    stream SQLInput ストリーム
	 * @param    typeName ＳＱＬタイプの文字列
	 * @throws SQLException
	 */
	public void readSQL( final SQLInput stream, final String typeName ) throws SQLException {
		sql_type = typeName;

		lineNo     = stream.readInt();
		codeKaihai = stream.readString();
		curdate    = stream.readString();
		pgid       = stream.readString();
		userid     = stream.readString();
	}

	/**
	 *  データベース内部に内部属性を設定します。
	 *
	 * @og.rev 4.3.0.0 (2008/07/22) 日付、PG、ユーザーIDを追加
	 *
	 * @param    stream SQLOutput ストリーム
	 * @throws SQLException
	 */
	public void writeSQL( final SQLOutput stream ) throws SQLException {
		stream.writeInt( lineNo );
		stream.writeString( codeKaihai );
		stream.writeString( curdate );
		stream.writeString( pgid );
		stream.writeString( userid );
	}
}
